/*
 * Decompiled with CFR 0.152.
 */
package noesis.io.graphics;

import ikor.model.graphics.Style;
import ikor.model.graphics.colors.ColorMap;
import ikor.util.indexer.Indexer;
import java.awt.Color;
import noesis.io.graphics.NetworkRenderer;

public abstract class LinkRenderer {
    public static final int DEFAULT_WIDTH = 1;
    private int width = 1;
    private Indexer<Long> widthIndex;
    private Indexer<Long> colorIndex;
    private ColorMap colorMap;

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        if (width >= 0) {
            this.width = width;
        }
    }

    public final Indexer<Long> getWidthIndexer() {
        return this.widthIndex;
    }

    public void setWidthIndexer(Indexer<Long> widthIndex) {
        this.widthIndex = widthIndex;
    }

    public final int getWidth(int source, int target) {
        if (this.widthIndex == null) {
            return this.width;
        }
        return this.width + this.widthIndex.index((long)source << 32 | (long)target);
    }

    public final int getWidthIndex(int source, int target) {
        if (this.widthIndex == null) {
            return -1;
        }
        return this.widthIndex.index((long)source << 32 | (long)target);
    }

    public final Indexer<Long> getColorIndexer() {
        return this.colorIndex;
    }

    public final void setColorIndexer(Indexer<Long> colorIndex) {
        this.colorIndex = colorIndex;
    }

    public final ColorMap getColorMap() {
        return this.colorMap;
    }

    public void setColorMap(ColorMap colorMap) {
        this.colorMap = colorMap;
    }

    public final int getColorIndex(int source, int target) {
        int index = 0;
        if (this.colorIndex != null) {
            index = this.colorIndex.index((long)source << 32 | (long)target);
            if (index < 0) {
                index = 0;
            } else if (index >= this.colorMap.size()) {
                index = this.colorMap.size() - 1;
            }
        }
        return index;
    }

    public final Color getColor(int source, int target) {
        return this.colorMap.getColor(this.getColorIndex(source, target));
    }

    public abstract Style getStyle(int var1, int var2);

    public abstract void render(NetworkRenderer var1, int var2, int var3);

    public abstract void update(NetworkRenderer var1, int var2, int var3);
}

