/*
 * Decompiled with CFR 0.152.
 */
package noesis.io.graphics;

import ikor.model.graphics.Drawing;
import noesis.Attribute;
import noesis.AttributeNetwork;
import noesis.io.graphics.BackgroundRenderer;
import noesis.io.graphics.DefaultBackgroundRenderer;
import noesis.io.graphics.DefaultLinkRenderer;
import noesis.io.graphics.DefaultNodeRenderer;
import noesis.io.graphics.LinkRenderer;
import noesis.io.graphics.NodeRenderer;

public class NetworkRenderer
extends Drawing {
    private AttributeNetwork network;
    private Attribute<Double> x;
    private Attribute<Double> y;
    private BackgroundRenderer backgroundRenderer;
    private NodeRenderer nodeRenderer;
    private LinkRenderer linkRenderer;

    public NetworkRenderer(AttributeNetwork network, int width, int height) {
        super(width, height);
        this.setNetwork(network);
        this.backgroundRenderer = new DefaultBackgroundRenderer();
        this.nodeRenderer = new DefaultNodeRenderer();
        this.linkRenderer = new DefaultLinkRenderer();
    }

    public AttributeNetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(AttributeNetwork network) {
        this.network = network;
        if (network != null) {
            this.x = network.getNodeAttribute("x");
            this.y = network.getNodeAttribute("y");
        } else {
            this.x = null;
            this.y = null;
        }
    }

    public BackgroundRenderer getBackgroundRenderer() {
        return this.backgroundRenderer;
    }

    public void setBackgroundRenderer(BackgroundRenderer backgroundRenderer) {
        this.backgroundRenderer = backgroundRenderer;
    }

    public NodeRenderer getNodeRenderer() {
        return this.nodeRenderer;
    }

    public void setNodeRenderer(NodeRenderer nodeRenderer) {
        this.nodeRenderer = nodeRenderer;
    }

    public LinkRenderer getLinkRenderer() {
        return this.linkRenderer;
    }

    public void setLinkRenderer(LinkRenderer linkRenderer) {
        this.linkRenderer = linkRenderer;
    }

    public void render() {
        super.clear();
        if (this.backgroundRenderer != null) {
            this.backgroundRenderer.render(this);
        }
        if (this.network != null) {
            int node = 0;
            while (node < this.network.size()) {
                int index = 0;
                while (index < this.network.outDegree(node)) {
                    this.render(node, this.network.outLink(node, index));
                    ++index;
                }
                ++node;
            }
            node = 0;
            while (node < this.network.size()) {
                this.render(node);
                ++node;
            }
        }
    }

    protected void render(int node) {
        if (this.network != null) {
            this.nodeRenderer.render(this, node);
        }
    }

    protected void render(int source, int target) {
        this.linkRenderer.render(this, source, target);
    }

    @Override
    public void update() {
        if (this.backgroundRenderer != null) {
            this.backgroundRenderer.update(this);
        }
        if (this.network != null) {
            int node = 0;
            while (node < this.network.size()) {
                this.update(node);
                ++node;
            }
        }
    }

    public void update(int node) {
        if (this.network != null) {
            int index = 0;
            while (index < this.network.outDegree(node)) {
                this.update(node, this.network.outLink(node, index));
                ++index;
            }
            index = 0;
            while (index < this.network.inDegree(node)) {
                this.update(this.network.inLink(node, index), node);
                ++index;
            }
            this.nodeRenderer.update(this, node);
        }
    }

    protected void update(int source, int target) {
        this.linkRenderer.update(this, source, target);
    }

    public String getNodeId(int node) {
        return "node" + node;
    }

    public int getNodeIndex(String id) {
        if (id.startsWith("node")) {
            int dashIndex = id.indexOf("-");
            if (dashIndex == -1) {
                return Integer.parseInt(id.substring(4));
            }
            return Integer.parseInt(id.substring(4, dashIndex));
        }
        return -1;
    }

    public String getLinkId(int source, int target) {
        return "link-s" + this.getNodeId(source) + "-t" + this.getNodeId(target);
    }

    public int getLinkSourceIndex(String id) {
        if (id.startsWith("link")) {
            return this.getNodeIndex(id.substring(6, id.indexOf("-t")));
        }
        return -1;
    }

    public int getLinkTargetIndex(String id) {
        if (id.startsWith("link")) {
            return this.getNodeIndex(id.substring(id.indexOf("-t") + 2));
        }
        return -1;
    }

    public int getX(int node) {
        if (this.x != null) {
            return (int)((double)this.getWidth() * (Double)this.x.get(node));
        }
        return 0;
    }

    public int getY(int node) {
        if (this.y != null) {
            return (int)((double)this.getHeight() * (1.0 - (Double)this.y.get(node)));
        }
        return 0;
    }
}

