/*
 * Decompiled with CFR 0.152.
 */
package noesis.io.graphics;

import ikor.model.ui.DatasetSelection;
import noesis.AttributeNetwork;
import noesis.io.graphics.DefaultLinkSelectionRenderer;
import noesis.io.graphics.DefaultNodeSelectionRenderer;
import noesis.io.graphics.LinkSelectionRenderer;
import noesis.io.graphics.NetworkRenderer;
import noesis.io.graphics.NodeSelectionRenderer;

public class NetworkSelectionRenderer
extends NetworkRenderer {
    private NodeSelectionRenderer nodeSelectionRenderer;
    private LinkSelectionRenderer linkSelectionRenderer;

    public NetworkSelectionRenderer(AttributeNetwork network, DatasetSelection nodeSelection, DatasetSelection linkSelection, int width, int height) {
        super(network, width, height);
        this.nodeSelectionRenderer = new DefaultNodeSelectionRenderer(this, nodeSelection);
        this.linkSelectionRenderer = new DefaultLinkSelectionRenderer(this, linkSelection);
    }

    public NodeSelectionRenderer getNodeSelectionRenderer() {
        return this.nodeSelectionRenderer;
    }

    public void setNodeSelectionRenderer(NodeSelectionRenderer nodeSelectionRenderer) {
        this.nodeSelectionRenderer = nodeSelectionRenderer;
    }

    public LinkSelectionRenderer getLinkSelectionRenderer() {
        return this.linkSelectionRenderer;
    }

    public void setLinkSelectionRenderer(LinkSelectionRenderer linkSelectionRenderer) {
        this.linkSelectionRenderer = linkSelectionRenderer;
    }

    @Override
    public void render(int node) {
        super.render(node);
        if (this.getNetwork() != null) {
            this.nodeSelectionRenderer.render(this, node);
        }
    }

    @Override
    public void update(int node) {
        super.update(node);
        if (this.getNetwork() != null) {
            this.nodeSelectionRenderer.update(this, node);
        }
    }

    @Override
    public void render(int source, int target) {
        this.linkSelectionRenderer.render(this, source, target);
        super.render(source, target);
    }

    @Override
    public void update(int source, int target) {
        super.update(source, target);
        this.linkSelectionRenderer.update(this, source, target);
    }
}

