/*
 * Decompiled with CFR 0.152.
 */
package noesis.io.graphics;

import ikor.model.graphics.Style;
import ikor.model.graphics.colors.ColorMap;
import ikor.util.indexer.Indexer;
import java.awt.Color;
import noesis.io.graphics.NetworkRenderer;

public abstract class NodeRenderer {
    public static final int DEFAULT_SIZE = 10;
    public static final int DEFAULT_WIDTH = 2;
    private int size = 10;
    private Indexer<Integer> sizeIndex;
    private Indexer<Integer> colorIndex;
    private ColorMap colorMap;

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int size) {
        if (size >= 0) {
            this.size = size;
        }
    }

    public final Indexer<Integer> getSizeIndexer() {
        return this.sizeIndex;
    }

    public final void setSizeIndexer(Indexer<Integer> sizeIndex) {
        this.sizeIndex = sizeIndex;
    }

    public final int getSize(int node) {
        if (this.sizeIndex == null) {
            return this.size;
        }
        return this.size + this.sizeIndex.index(node);
    }

    public final Indexer<Integer> getColorIndexer() {
        return this.colorIndex;
    }

    public final void setColorIndexer(Indexer<Integer> colorIndex) {
        this.colorIndex = colorIndex;
    }

    public final ColorMap getColorMap() {
        return this.colorMap;
    }

    public void setColorMap(ColorMap colorMap) {
        this.colorMap = colorMap;
    }

    public final int getColorIndex(int node) {
        int index = 0;
        if (this.colorIndex != null) {
            index = this.colorIndex.index(node);
            if (index < 0) {
                index = 0;
            } else if (index >= this.colorMap.size()) {
                index = this.colorMap.size() - 1;
            }
        }
        return index;
    }

    public final Color getColor(int node) {
        return this.colorMap.getColor(this.getColorIndex(node));
    }

    public abstract Style getStyle(int var1);

    public abstract void render(NetworkRenderer var1, int var2);

    public abstract void update(NetworkRenderer var1, int var2);
}

