/*
 * Decompiled with CFR 0.152.
 */
package noesis.model.random;

import ikor.math.random.Random;
import noesis.model.random.RandomNetwork;

public class WattsStrogatzNetwork
extends RandomNetwork {
    private double probability;

    public WattsStrogatzNetwork(int nodes, int neighbors, double rewiringProbability) {
        this.probability = rewiringProbability;
        this.setID("WATTS-STROGATZ NETWORK (n=" + nodes + ", k=" + neighbors + ", beta=" + this.probability + ")");
        this.setSize(nodes);
        int k = neighbors / 2;
        int i = 0;
        while (i < nodes) {
            int j = 1;
            while (j <= k) {
                this.add2(i, (i + j) % nodes);
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < nodes) {
            int j = 1;
            while (j <= k) {
                if (Random.random() < this.probability) {
                    int target;
                    this.remove2(i2, (i2 + j) % nodes);
                    while ((target = Random.random(nodes)) == i2 || this.contains(i2, target)) {
                    }
                    this.add2(i2, target);
                }
                ++j;
            }
            ++i2;
        }
    }

    public double getRewiringProbability() {
        return this.probability;
    }
}

