/*
 * Decompiled with CFR 0.152.
 */
package noesis.model.regular;

import noesis.model.regular.RegularNetwork;

public class BinaryTreeNetwork
extends RegularNetwork {
    public final int ROOT = 0;

    public BinaryTreeNetwork(int size) {
        this.setSize(size);
        this.setID("BINARY NETWORK (n=" + size + ")");
        int i = 1;
        while (i < size) {
            this.add(i, this.parent(i));
            this.add(this.parent(i), i);
            ++i;
        }
    }

    public int parent(int node) {
        return (node - 1) / 2;
    }

    public int leftChild(int node) {
        return 2 * node;
    }

    public int rightChild(int node) {
        return 2 * node + 1;
    }

    public int height() {
        return this.height(this.size() - 1);
    }

    public int height(int node) {
        return (int)Math.floor(Math.log(node + 1) / Math.log(2.0));
    }

    public int leaves() {
        return (this.size() + 1) / 2;
    }

    public int oneChildNodes() {
        if (this.size() % 2 == 0) {
            return 1;
        }
        return 0;
    }

    public int twoChildrenNodes() {
        if (this.size() > 2) {
            return (this.size() - 1) / 2;
        }
        return 0;
    }

    public int internalNodes() {
        return this.size() - this.leaves();
    }

    public boolean inSameSubtree(int a, int b) {
        int max = Math.max(a, b);
        int min = Math.min(a, b);
        int current = max;
        while (current > min) {
            current = this.parent(current);
        }
        return current == min;
    }

    public int firstCommonAncestor(int a, int b) {
        int min = Math.min(a, b);
        int max = Math.max(a, b);
        while (max != min) {
            int parent = this.parent(max);
            if (parent > min) {
                max = parent;
                continue;
            }
            max = min;
            min = parent;
        }
        return max;
    }

    @Override
    public int distance(int origin, int destination) {
        if (origin != destination) {
            if (this.inSameSubtree(origin, destination)) {
                return Math.abs(this.height(destination) - this.height(origin));
            }
            int commonAncestor = this.firstCommonAncestor(origin, destination);
            return this.height(origin) + this.height(destination) - 2 * this.height(commonAncestor);
        }
        return 0;
    }

    private int lastLevel() {
        return this.size() - ((int)Math.pow(2.0, this.height()) - 1);
    }

    @Override
    public int diameter() {
        int height = this.height();
        if ((double)this.lastLevel() > Math.pow(2.0, height - 1)) {
            return 2 * height;
        }
        return 2 * height - 1;
    }

    @Override
    public int radius(int node) {
        int leftmost = (int)Math.pow(2.0, this.height());
        int last = this.size() - 1;
        if (this.size() > 2) {
            if (node == 0) {
                return this.height();
            }
            if (this.firstCommonAncestor(node, last) == 0) {
                return this.height() + this.height(node);
            }
            if (this.firstCommonAncestor(node, leftmost) == 0) {
                return this.height() + this.height(node);
            }
            return this.height() + this.height(node) - 1;
        }
        return this.size() - 1;
    }

    @Override
    public int minDegree() {
        if (this.size() > 1) {
            return 1;
        }
        return 0;
    }

    @Override
    public int maxDegree() {
        if (this.size() > 4) {
            return 3;
        }
        return (this.size() + 1) / 2;
    }

    @Override
    public double averageDegree() {
        return ((double)this.leaves() + 2.0 * (double)this.oneChildNodes() + 3.0 * (double)this.twoChildrenNodes() - 1.0) / (double)this.size();
    }

    @Override
    public double averagePathLength() {
        double s = 0.0;
        int i = 0;
        while (i < this.size()) {
            s += this.averagePathLength(i);
            ++i;
        }
        return s / (double)this.size();
    }

    @Override
    public double averagePathLength(int i) {
        double sum = 0.0;
        int treeHeight = this.height();
        int nodeHeight = this.height(i);
        int down = 1;
        while (nodeHeight + down <= treeHeight) {
            sum += Math.pow(2.0, down) * (double)down;
            ++down;
        }
        int up = 1;
        while (nodeHeight - up >= 0) {
            sum += (double)(1 * up);
            down = 1;
            while (nodeHeight - up + down <= treeHeight) {
                sum += Math.pow(2.0, down - 1) * (double)(up + down);
                ++down;
            }
            ++up;
        }
        return sum / (double)(this.size() - 1);
    }

    @Override
    public double clusteringCoefficient(int node) {
        return 0.0;
    }

    @Override
    public double betweenness(int node) {
        int h = this.height() - this.height(node);
        double leftChildren = Math.pow(2.0, h) - 1.0;
        double rightChildren = Math.pow(2.0, h) - 1.0;
        double upNodes = (double)this.size() - leftChildren - rightChildren - 1.0;
        return (double)(2 * this.size() - 1) + 2.0 * leftChildren * rightChildren + 2.0 * upNodes * (leftChildren + rightChildren);
    }
}

