/*
 * Decompiled with CFR 0.152.
 */
package noesis.model.regular;

import noesis.model.regular.RegularNetwork;

public class HypercubeNetwork
extends RegularNetwork {
    private int dimension;

    public HypercubeNetwork(int dimension) {
        int size = 1 << dimension;
        this.setID("HYPERCUBE NETWORK (D=" + dimension + ")");
        this.setSize(size);
        this.dimension = dimension;
        int i = 0;
        while (i < size) {
            int d = 0;
            while (d < dimension) {
                int bit = 1 << d;
                this.add(i, i ^ bit);
                ++d;
            }
            ++i;
        }
    }

    @Override
    public int distance(int origin, int destination) {
        int diff = 0;
        int d = 0;
        while (d < this.dimension) {
            int bit = 1 << d;
            if ((origin & bit) != (destination & bit)) {
                ++diff;
            }
            ++d;
        }
        return diff;
    }

    @Override
    public int diameter() {
        return this.dimension;
    }

    @Override
    public int radius(int node) {
        return this.dimension;
    }

    @Override
    public int minDegree() {
        return this.dimension;
    }

    @Override
    public int maxDegree() {
        return this.dimension;
    }

    @Override
    public double averageDegree() {
        return this.dimension;
    }

    @Override
    public double averagePathLength() {
        return (double)this.size() / (double)(this.size() - 1) * ((double)this.dimension / 2.0);
    }

    @Override
    public double averagePathLength(int i) {
        return this.averagePathLength();
    }

    @Override
    public double clusteringCoefficient(int node) {
        return 0.0;
    }

    @Override
    public double betweenness(int node) {
        return Math.pow(2.0, this.dimension - 1) * (double)(this.dimension + 2);
    }
}

