/*
 * Decompiled with CFR 0.152.
 */
package noesis.model.regular;

import noesis.model.regular.RegularNetwork;

public class MeshNetwork
extends RegularNetwork {
    private int rows;
    private int columns;

    public MeshNetwork(int rows, int columns) {
        int size = rows * columns;
        this.setID("MESH NETWORK (" + rows + "x" + columns + ")");
        this.setSize(size);
        this.columns = columns;
        this.rows = rows;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                if (j + 1 < columns) {
                    this.add(this.index(i, j), this.index(i, j + 1));
                    this.add(this.index(i, j + 1), this.index(i, j));
                }
                if (i + 1 < rows) {
                    this.add(this.index(i, j), this.index(i + 1, j));
                    this.add(this.index(i + 1, j), this.index(i, j));
                }
                ++j;
            }
            ++i;
        }
    }

    public int index(int row, int column) {
        return row * this.columns + column;
    }

    public int row(int index) {
        return index / this.columns;
    }

    public int column(int index) {
        return index % this.columns;
    }

    @Override
    public int distance(int origin, int destination) {
        return Math.abs(this.row(origin) - this.row(destination)) + Math.abs(this.column(origin) - this.column(destination));
    }

    @Override
    public int diameter() {
        return this.rows + this.columns - 2;
    }

    @Override
    public int radius(int node) {
        return Math.max(this.row(node), this.rows - 1 - this.row(node)) + Math.max(this.column(node), this.columns - 1 - this.column(node));
    }

    @Override
    public int minDegree() {
        return 2;
    }

    @Override
    public int maxDegree() {
        return 4;
    }

    @Override
    public double averageDegree() {
        int corners = 4;
        int borders = 2 * (this.rows + this.columns - 4);
        int internal = (this.rows - 2) * (this.columns - 2);
        return ((double)corners * 2.0 + (double)borders * 3.0 + (double)internal * 4.0) / (double)this.size();
    }

    @Override
    public double averagePathLength() {
        return (double)(this.rows + this.columns) / 3.0;
    }

    public double tandemAveragePathLength(int n) {
        return ((double)n + 1.0) / 3.0;
    }

    @Override
    public double averagePathLength(int i) {
        int row = this.row(i);
        int column = this.column(i);
        double sumLeft = column * (column + 1) / 2;
        double sumRight = (this.columns - column) * (this.columns - column - 1) / 2;
        double sumUp = row * (row + 1) / 2;
        double sumDown = (this.rows - row) * (this.rows - row - 1) / 2;
        return ((double)this.rows * (sumLeft + sumRight) + (double)this.columns * (sumUp + sumDown)) / (double)(this.size() - 1);
    }

    @Override
    public double clusteringCoefficient(int node) {
        return 0.0;
    }

    @Override
    public double betweenness(int node) {
        throw new UnsupportedOperationException("Unknown analytic expression for betweenness in a 2D mesh");
    }
}

