/*
 * Decompiled with CFR 0.152.
 */
package noesis.model.regular;

import noesis.model.regular.RegularNetwork;

public class RingNetwork
extends RegularNetwork {
    public RingNetwork(int size) {
        this.setSize(size);
        this.setID("RING (n=" + size + ")");
        int i = 0;
        while (i < size) {
            this.add(i, (i + 1) % size);
            this.add(i, (i + size - 1) % size);
            ++i;
        }
    }

    @Override
    public int distance(int origin, int destination) {
        int diff = Math.abs(destination - origin);
        if ((double)diff < (double)this.size() / 2.0) {
            return diff;
        }
        return this.size() - diff;
    }

    @Override
    public int diameter() {
        return this.size() / 2;
    }

    @Override
    public int radius(int i) {
        if (this.size() > 2) {
            return this.diameter();
        }
        return this.size() - 1;
    }

    @Override
    public int minDegree() {
        return 2;
    }

    @Override
    public int maxDegree() {
        return 2;
    }

    @Override
    public double averageDegree() {
        return 2.0;
    }

    @Override
    public double averagePathLength() {
        double n = this.size();
        if (n % 2.0 == 0.0) {
            return n * n / (4.0 * (n - 1.0));
        }
        return (n + 1.0) / 4.0;
    }

    @Override
    public double averagePathLength(int node) {
        return this.averagePathLength();
    }

    @Override
    public double clusteringCoefficient(int node) {
        if (this.size() == 3) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public double betweenness(int node) {
        return this.size() * this.size() / 4 + this.size();
    }
}

