/*
 * Decompiled with CFR 0.152.
 */
package noesis.model.regular;

import noesis.model.regular.RegularNetwork;

public class StarNetwork
extends RegularNetwork {
    public final int CENTER = 0;

    public StarNetwork(int size) {
        this.setSize(size);
        this.setID("STAR NETWORK (n=" + size + ")");
        int i = 1;
        while (i < size) {
            this.add(0, i);
            this.add(i, 0);
            ++i;
        }
    }

    @Override
    public int distance(int origin, int destination) {
        if (origin != destination) {
            if (origin != 0 && destination != 0) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public int diameter() {
        if (this.size() > 2) {
            return 2;
        }
        return this.size() - 1;
    }

    @Override
    public int radius(int node) {
        if (node == 0) {
            return 1;
        }
        if (this.size() > 2) {
            return 2;
        }
        return this.size() - 1;
    }

    @Override
    public int minDegree() {
        return 1;
    }

    @Override
    public int maxDegree() {
        return this.size() - 1;
    }

    @Override
    public double averageDegree() {
        return 2.0 * ((double)this.size() - 1.0) / (double)this.size();
    }

    @Override
    public double averagePathLength() {
        return 2.0 * ((double)this.size() - 1.0) / (double)this.size();
    }

    @Override
    public double averagePathLength(int node) {
        if (node == 0) {
            return 1.0;
        }
        return (2.0 * (double)this.size() - 3.0) / (double)(this.size() - 1);
    }

    @Override
    public double clusteringCoefficient(int node) {
        return 0.0;
    }

    @Override
    public double betweenness(int node) {
        if (node == 0) {
            return this.size() * this.size() - (this.size() - 1);
        }
        return 2 * this.size() - 1;
    }
}

