/*
 * Decompiled with CFR 0.152.
 */
package noesis.model.regular;

import noesis.model.regular.RegularNetwork;

public class TandemNetwork
extends RegularNetwork {
    public TandemNetwork(int size) {
        this.setSize(size);
        this.setID("TANDEM (n=" + size + ")");
        int i = 0;
        while (i < size) {
            if (i < size) {
                this.add(i, i + 1);
            }
            if (i > 0) {
                this.add(i, i - 1);
            }
            ++i;
        }
    }

    @Override
    public int distance(int origin, int destination) {
        return Math.abs(destination - origin);
    }

    @Override
    public int diameter() {
        return this.size() - 1;
    }

    @Override
    public int radius(int i) {
        return Math.max(i, this.size() - i - 1);
    }

    @Override
    public int minDegree() {
        return 1;
    }

    @Override
    public int maxDegree() {
        if (this.size() > 2) {
            return 2;
        }
        return this.size() - 1;
    }

    @Override
    public double averageDegree() {
        if (this.size() > 2) {
            return ((double)(this.size() - 2) * 2.0 + 2.0) / (double)this.size();
        }
        return this.size() - 1;
    }

    @Override
    public double averagePathLength() {
        return ((double)this.size() + 1.0) / 3.0;
    }

    @Override
    public double averagePathLength(int i) {
        double sumLeft = i * (i + 1) / 2;
        double sumRight = (this.size() - i) * (this.size() - i - 1) / 2;
        return (sumLeft + sumRight) / ((double)this.size() - 1.0);
    }

    @Override
    public double clusteringCoefficient(int node) {
        return 0.0;
    }

    @Override
    public double betweenness(int node) {
        return 2 * (node + 1) * (this.size() - node) - 1;
    }
}

