/*
 * Decompiled with CFR 0.152.
 */
package noesis.model.regular;

import noesis.model.regular.RegularNetwork;

public class ToroidalNetwork
extends RegularNetwork {
    private int rows;
    private int columns;

    public ToroidalNetwork(int rows, int columns) {
        int size = rows * columns;
        this.setID("TOROIDAL NETWORK (" + rows + "x" + columns + ")");
        this.setSize(size);
        this.columns = columns;
        this.rows = rows;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                this.add(this.index(i, j), this.index(i, (j + 1) % columns));
                this.add(this.index(i, (j + 1) % columns), this.index(i, j));
                this.add(this.index(i, j), this.index((i + 1) % rows, j));
                this.add(this.index((i + 1) % rows, j), this.index(i, j));
                ++j;
            }
            ++i;
        }
    }

    public int index(int row, int column) {
        return row * this.columns + column;
    }

    public int row(int index) {
        return index / this.columns;
    }

    public int column(int index) {
        return index % this.columns;
    }

    private int ringDistance(int ring, int origin, int destination) {
        int diff = Math.abs(destination - origin);
        if ((double)diff < (double)ring / 2.0) {
            return diff;
        }
        return ring - diff;
    }

    @Override
    public int distance(int origin, int destination) {
        return this.ringDistance(this.rows, this.row(origin), this.row(destination)) + this.ringDistance(this.columns, this.column(origin), this.column(destination));
    }

    @Override
    public int diameter() {
        return this.rows / 2 + this.columns / 2;
    }

    @Override
    public int radius(int node) {
        return this.diameter();
    }

    @Override
    public int minDegree() {
        return 4;
    }

    @Override
    public int maxDegree() {
        return 4;
    }

    @Override
    public double averageDegree() {
        return 4.0;
    }

    private double ringSumPathLengths(int n) {
        int d = n / 2;
        if (n % 2 == 0) {
            return d * (d - 1) + d;
        }
        return d * (d - 1) + 2 * d;
    }

    @Override
    public double averagePathLength() {
        return ((double)this.columns * this.ringSumPathLengths(this.rows) + (double)this.rows * this.ringSumPathLengths(this.columns)) / (double)(this.size() - 1);
    }

    @Override
    public double averagePathLength(int i) {
        return this.averagePathLength();
    }

    @Override
    public double clusteringCoefficient(int node) {
        return 0.0;
    }

    @Override
    public double betweenness(int node) {
        double x = this.rows + this.columns + 4;
        if (this.rows % 2 == 0 && this.columns % 2 == 0) {
            return (double)this.size() * x / 4.0;
        }
        if (this.rows % 2 == 1 && this.columns % 2 == 0) {
            return (double)this.columns * ((double)this.rows * x - 1.0) / 4.0;
        }
        if (this.rows % 2 == 0 && this.columns % 2 == 1) {
            return (double)this.rows * ((double)this.columns * x - 1.0) / 4.0;
        }
        return ((double)this.rows * x - 1.0) * ((double)this.columns * x - 1.0) / (4.0 * x);
    }
}

