/*
 * Decompiled with CFR 0.152.
 */
package noesis.network;

import noesis.AttributeNetwork;
import noesis.Network;
import noesis.network.AugmentedAttribute;
import noesis.network.AugmentedLinkAttribute;

public class AugmentedNetwork
extends AttributeNetwork {
    AttributeNetwork base;

    public AugmentedNetwork(Network original) {
        this.base = original instanceof AttributeNetwork ? (AttributeNetwork)original : new AttributeNetwork(original);
        this.setSize(this.base.size());
        int i = 0;
        while (i < this.base.getNodeAttributeCount()) {
            this.addNodeAttribute(new AugmentedAttribute(this.base.getNodeAttribute(i)));
            ++i;
        }
        i = 0;
        while (i < this.base.getLinkAttributeCount()) {
            this.addLinkAttribute(new AugmentedLinkAttribute((AttributeNetwork)this, this.base.getLinkAttribute(i)));
            ++i;
        }
    }

    @Override
    public int links() {
        return this.base.links() + super.links();
    }

    @Override
    public int index(int source, int destination) {
        int pos = this.base.index(source, destination);
        if (pos != -1) {
            return pos;
        }
        pos = super.index(source, destination);
        if (pos != -1) {
            return this.base.links() + pos;
        }
        return -1;
    }

    @Override
    public int getLinkIndex(int source, int destination) {
        int position = this.base.getLinkIndex(source, destination);
        if (position == -1 && (position = super.getLinkIndex(source, destination)) != -1) {
            position = this.base.outDegree(source) + position;
        }
        return position;
    }

    @Override
    public Integer get(int source, int destination) {
        if (this.getLinkIndex(source, destination) != -1) {
            return destination;
        }
        return null;
    }

    @Override
    public final int inDegree(int node) {
        int degree = super.inDegree(node);
        if (node < this.base.size()) {
            degree += this.base.inDegree(node);
        }
        return degree;
    }

    @Override
    public final int outDegree(int node) {
        int degree = super.outDegree(node);
        if (node < this.base.size()) {
            degree += this.base.outDegree(node);
        }
        return degree;
    }

    @Override
    public int outLink(int node, int index) {
        int baseDegree = node < this.base.size() ? this.base.outDegree(node) : 0;
        if (index < baseDegree) {
            return this.base.outLink(node, index);
        }
        return super.outLink(node, index - baseDegree);
    }

    @Override
    public int inLink(int node, int index) {
        int baseDegree = node < this.base.size() ? this.base.inDegree(node) : 0;
        if (index < baseDegree) {
            return this.base.inLink(node, index);
        }
        return super.inLink(node, index - baseDegree);
    }
}

