/*
 * Decompiled with CFR 0.152.
 */
package noesis.network;

import noesis.AttributeNetwork;
import noesis.Network;
import noesis.network.FilteredAttribute;
import noesis.network.FilteredLinkAttribute;
import noesis.network.filter.NetworkFilter;

public class FilteredNetwork
extends AttributeNetwork {
    private AttributeNetwork net;
    private NetworkFilter filter;
    private int[] index;
    private int[] reverse;
    private int nodes;
    private int links;

    public FilteredNetwork(Network original, NetworkFilter filter) {
        if (original instanceof AttributeNetwork) {
            this.net = (AttributeNetwork)original;
            int i = 0;
            while (i < this.net.getNodeAttributeCount()) {
                this.addNodeAttribute(new FilteredAttribute(this, this.net.getNodeAttribute(i)));
                ++i;
            }
            int j = 0;
            while (j < this.net.getLinkAttributeCount()) {
                this.addLinkAttribute(new FilteredLinkAttribute(this, this.net.getLinkAttribute(j)));
                ++j;
            }
        } else {
            this.net = new AttributeNetwork(original);
        }
        this.setFilter(filter);
    }

    public NetworkFilter getFilter() {
        return this.filter;
    }

    public void setFilter(NetworkFilter filter) {
        this.filter = filter;
        this.index = new int[this.net.size()];
        this.reverse = new int[this.net.size()];
        this.nodes = 0;
        this.links = 0;
        int i = 0;
        while (i < this.net.size()) {
            if (filter.node(i)) {
                this.index[this.nodes] = i;
                this.reverse[i] = this.nodes++;
                int degree = this.net.outDegree(i);
                int j = 0;
                while (j < degree) {
                    if (filter.link(i, j)) {
                        ++this.links;
                    }
                    ++j;
                }
            } else {
                this.reverse[i] = -1;
            }
            ++i;
        }
    }

    @Override
    public int nodes() {
        return this.nodes;
    }

    @Override
    public int links() {
        return this.links;
    }

    @Override
    public Integer get(int node) {
        return this.index[node];
    }

    @Override
    public boolean contains(Integer node) {
        return node >= 0 && node < this.net.size() && this.reverse[node] != -1;
    }

    @Override
    public int index(Integer node) {
        if (node >= 0 && node < this.net.size()) {
            return this.reverse[node];
        }
        return -1;
    }

    @Override
    public int inDegree(int node) {
        int degree = 0;
        if (node >= 0 && node < this.nodes) {
            int original = this.index[node];
            int originalDegree = this.net.inDegree(original);
            if (node < this.nodes && originalDegree > 0) {
                int j = 0;
                while (j < originalDegree) {
                    int link;
                    int source = this.net.inLink(original, j);
                    if (this.filter.link(source, link = this.net.getLinkIndex(source, original))) {
                        ++degree;
                    }
                    ++j;
                }
            }
        }
        return degree;
    }

    @Override
    public int outDegree(int node) {
        int original;
        int originalDegree;
        int degree = 0;
        if (node >= 0 && node < this.nodes && (originalDegree = this.net.outDegree(original = this.index[node])) > 0) {
            int j = 0;
            while (j < originalDegree) {
                if (this.filter.link(original, j)) {
                    ++degree;
                }
                ++j;
            }
        }
        return degree;
    }

    @Override
    public int outLink(int node, int link) {
        int original = this.index[node];
        int current = -1;
        int position = -1;
        do {
            if (!this.filter.link(original, ++current)) continue;
            ++position;
        } while (position < link);
        return this.reverse[this.net.outLink(original, current)];
    }

    @Override
    public int inLink(int node, int link) {
        int current = -1;
        int position = -1;
        int originalNode = this.index[node];
        do {
            int originalLink;
            int originalSource;
            if (!this.filter.link(originalSource = this.net.inLink(originalNode, ++current), originalLink = this.net.getLinkIndex(originalSource, originalNode))) continue;
            ++position;
        } while (position < link);
        return this.reverse[this.net.inLink(originalNode, current)];
    }
}

