/*
 * Decompiled with CFR 0.152.
 */
package noesis.network;

import ikor.collection.CollectionFactory;
import ikor.collection.Dictionary;
import ikor.collection.util.Pair;
import noesis.Network;
import noesis.network.LinkIndexer;

public class LinkDictionaryIndex
implements LinkIndexer {
    private Network net;
    private Dictionary<Pair<Integer, Integer>, Integer> index;
    private Dictionary<Integer, Pair<Integer, Integer>> reverse;

    public LinkDictionaryIndex(Network net) {
        this.net = net;
        this.index = CollectionFactory.createDictionary();
        this.reverse = CollectionFactory.createDictionary();
    }

    public Network network() {
        return this.net;
    }

    @Override
    public int nodes() {
        return this.net.nodes();
    }

    @Override
    public int links() {
        return this.net.links();
    }

    public void add(int source, int destination) {
        int position = this.links();
        Pair<Integer, Integer> edge = new Pair<Integer, Integer>(source, destination);
        this.index.set(edge, position);
        this.reverse.set(position, edge);
    }

    public int remove(int source, int destination) {
        Pair<Integer, Integer> key = new Pair<Integer, Integer>(source, destination);
        int position = (Integer)this.index.get(key);
        int nlinks = this.links();
        if (position != -1) {
            int i = position;
            while (i < nlinks - 1) {
                Pair link = (Pair)this.reverse.get(i + 1);
                this.reverse.set(i, link);
                this.index.set(link, i);
                ++i;
            }
            this.reverse.remove(nlinks - 1);
            this.index.remove(key);
        }
        return position;
    }

    public void redirect(int oldSource, int oldDestination, int newSource, int newDestination) {
        Pair<Integer, Integer> oldKey = new Pair<Integer, Integer>(oldSource, oldDestination);
        Pair<Integer, Integer> newKey = new Pair<Integer, Integer>(newSource, newDestination);
        int position = (Integer)this.index.get(oldKey);
        this.index.remove(oldKey);
        this.index.set(newKey, position);
        this.reverse.set(position, newKey);
    }

    @Override
    public int index(int source, int destination) {
        Pair<Integer, Integer> key = new Pair<Integer, Integer>(source, destination);
        Integer pos = (Integer)this.index.get(key);
        if (pos != null) {
            return pos;
        }
        return -1;
    }

    @Override
    public int source(int link) {
        Pair value = (Pair)this.reverse.get(link);
        if (value != null) {
            return (Integer)value.first();
        }
        return -1;
    }

    @Override
    public int destination(int link) {
        Pair value = (Pair)this.reverse.get(link);
        if (value != null) {
            return (Integer)value.second();
        }
        return -1;
    }
}

