/*
 * Decompiled with CFR 0.152.
 */
package noesis.network;

import noesis.Network;
import noesis.network.LinkIndexer;

public class LinkIndex
implements LinkIndexer {
    private Network net;
    private int nodes;
    private int links;
    private int[] index;

    public LinkIndex(Network net) {
        this.net = net;
        this.rebuild();
    }

    public Network network() {
        return this.net;
    }

    @Override
    public int nodes() {
        return this.nodes;
    }

    @Override
    public int links() {
        return this.links;
    }

    public void rebuild() {
        this.nodes = this.net.size();
        this.links = this.net.links();
        this.index = new int[this.net.size()];
        int currentLink = 0;
        int node = 0;
        while (node < this.net.size()) {
            this.index[node] = currentLink;
            currentLink += this.net.outDegree(node);
            ++node;
        }
    }

    @Override
    public int index(int source, int destination) {
        int base = this.index[source];
        int link = 0;
        int degree = this.net.outDegree(source);
        while (link < degree && this.net.outLink(source, link) != destination) {
            ++link;
        }
        if (link < degree) {
            return base + link;
        }
        return -1;
    }

    @Override
    public int source(int link) {
        if (link >= this.links) {
            return -1;
        }
        int left = 0;
        int right = this.index.length - 1;
        int middle = (left + right) / 2;
        while (left <= right && this.index[middle] != link) {
            if (link < this.index[middle]) {
                right = middle - 1;
            } else {
                left = middle + 1;
            }
            middle = (left + right) / 2;
        }
        if (left > right) {
            return left - 1;
        }
        return middle;
    }

    @Override
    public int destination(int link) {
        int sourceNode = this.source(link);
        if (sourceNode != -1) {
            return this.net.outLink(sourceNode, link - this.index[sourceNode]);
        }
        return -1;
    }
}

