/*
 * Decompiled with CFR 0.152.
 */
package noesis.network.attribute;

import ikor.util.indexer.DictionaryIndexer;
import ikor.util.indexer.Indexer;
import noesis.Attribute;

public abstract class CategoricalAttributeIndexer<T>
extends Indexer<T> {
    private Attribute attribute;
    private int size;
    private DictionaryIndexer<String> valueIndex;

    public CategoricalAttributeIndexer(Attribute attribute, int size) {
        this.attribute = attribute;
        this.size = size;
        this.valueIndex = new DictionaryIndexer();
        int i = 0;
        while (i < attribute.size()) {
            Object object = attribute.get(i);
            if (object != null) {
                this.valueIndex.add(object.toString());
            }
            ++i;
        }
    }

    @Override
    public int min() {
        return 0;
    }

    @Override
    public int max() {
        return this.size - 1;
    }

    protected double factor() {
        double range = this.valueIndex.max();
        if (range > 0.0) {
            return (double)this.max() / range;
        }
        return 0.0;
    }

    protected Attribute getAttribute() {
        return this.attribute;
    }

    protected int getSize() {
        return this.size;
    }

    protected DictionaryIndexer<String> getValueIndex() {
        return this.valueIndex;
    }
}

