/*
 * Decompiled with CFR 0.152.
 */
package noesis.network.attribute;

import ikor.util.indexer.Indexer;
import ikor.util.indexer.LogValueIndexer;
import ikor.util.indexer.ValueIndexer;
import noesis.Attribute;

public abstract class NumericalAttributeIndexer<T>
extends Indexer<T> {
    private Attribute attribute;
    private int size;
    private Indexer<Double> valueIndex;

    public NumericalAttributeIndexer(Attribute attribute, int size) {
        this(attribute, size, false);
    }

    public NumericalAttributeIndexer(Attribute attribute, int size, boolean logScale) {
        this.attribute = attribute;
        this.size = size;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        int i = 0;
        while (i < attribute.size()) {
            Number object = (Number)attribute.get(i);
            if (object != null) {
                double value = object.doubleValue();
                if (value < min) {
                    min = value;
                }
                if (value > max) {
                    max = value;
                }
            }
            ++i;
        }
        this.valueIndex = logScale ? new LogValueIndexer(min, max, size - 1) : new ValueIndexer(min, max, size - 1);
    }

    @Override
    public int min() {
        return 0;
    }

    @Override
    public int max() {
        return this.size - 1;
    }

    protected Attribute getAttribute() {
        return this.attribute;
    }

    protected int getSize() {
        return this.size;
    }

    protected Indexer<Double> getValueIndex() {
        return this.valueIndex;
    }
}

