/*
 * Decompiled with CFR 0.152.
 */
package noesis.network.filter;

import ikor.collection.CollectionFactory;
import ikor.collection.Set;
import noesis.Network;
import noesis.network.filter.NetworkFilter;

public class LinkFilter
implements NetworkFilter {
    private Network net;
    private Set<Long> linkset;

    public LinkFilter(Network net) {
        this.net = net;
        this.linkset = CollectionFactory.createSet();
    }

    public LinkFilter(Network net, int sourceIndex, int destinationIndex) {
        this(net);
        this.removeLink(sourceIndex, destinationIndex);
    }

    public void removeLink(int source, int destination) {
        int degree = this.net.outDegree(source);
        int link = 0;
        while (link < degree) {
            if (this.net.outLink(source, link) == destination) {
                this.linkset.add(this.key(source, link));
            }
            ++link;
        }
    }

    public void removeLinkByIndex(int node, int link) {
        this.linkset.add(this.key(node, link));
    }

    private long key(int node, int link) {
        return (long)node << 32 | (long)link;
    }

    @Override
    public boolean node(int node) {
        return true;
    }

    @Override
    public boolean link(int node, int link) {
        return !this.linkset.contains(this.key(node, link));
    }
}

