/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.console;

import ikor.parallel.Scheduler;
import ikor.parallel.scheduler.WorkStealingScheduler;
import ikor.util.Benchmark;
import ikor.util.log.Log;
import java.io.IOException;
import java.lang.reflect.Constructor;
import noesis.AttributeNetwork;
import noesis.Network;
import noesis.algorithms.communities.CommunityDetector;
import noesis.algorithms.communities.CommunityDetectorTask;
import noesis.algorithms.traversal.ConnectedComponents;
import noesis.analysis.NodeScore;
import noesis.analysis.structure.communities.CohesionCoefficient;
import noesis.analysis.structure.communities.CoverageCoefficient;
import noesis.analysis.structure.communities.ModularityCoefficient;
import noesis.analysis.structure.communities.SeparationCoefficient;
import noesis.analysis.structure.communities.SilhouetteCoefficient;
import noesis.ui.console.NetworkUtilities;
import noesis.ui.model.data.Report;

public class NetworkCommunities {
    public static void main(String[] args) throws IOException {
        Scheduler.set(new WorkStealingScheduler(16));
        if (args.length < 2) {
            System.err.println("NOESIS Network Community Detection:");
            System.err.println();
            System.err.println("  java noesis.ui.console.NetworkCommunities <file> <algorithm>");
        } else {
            Benchmark crono = new Benchmark();
            crono.start();
            Network net = NetworkUtilities.read(args[0]);
            NetworkUtilities.printNetworkInformation(net);
            int loops = NetworkCommunities.loops(net);
            System.out.println("- Loops: " + loops);
            int directedLinks = NetworkCommunities.directedLinks(net);
            System.out.println("- Directed links: " + directedLinks);
            if (directedLinks > 0) {
                net = NetworkCommunities.undirected(net);
            }
            if (loops > 0) {
                net = NetworkCommunities.withoutLoops(net);
            }
            if (directedLinks > 0 || loops > 0) {
                System.out.println("AFTER NETWORK NORMALIZATION...");
                NetworkUtilities.printNetworkInformation(net);
            }
            ConnectedComponents cc = new ConnectedComponents(net);
            cc.compute();
            System.out.println("- Connected components: " + cc.components());
            String algorithm = args[1];
            CommunityDetectorTask task = null;
            try {
                Class<?> detector = Class.forName(algorithm);
                Constructor<?> constructor = detector.getConstructor(AttributeNetwork.class);
                task = new CommunityDetectorTask((CommunityDetector)constructor.newInstance(net), (AttributeNetwork)net);
            }
            catch (Exception error) {
                Log.error("Community detection algorithm: Unable to instantiate algorithm: " + algorithm);
                Log.error(error.toString());
            }
            if (task != null) {
                System.out.println("COMMUNITY DETECTION");
                System.out.println("- Algorithm: " + algorithm);
                task.compute();
                NodeScore assignment = (NodeScore)task.getResult();
                Report report = new Report();
                report.add("Number of nodes", net.nodes());
                report.add("Number of communities", (int)(assignment.max() - assignment.min() + 1.0));
                ModularityCoefficient modularity = new ModularityCoefficient(net, assignment);
                report.add("Modularity", modularity.overallValue());
                CohesionCoefficient cohesion = new CohesionCoefficient(net, assignment);
                report.add("Cohesion", cohesion.overallValue());
                SeparationCoefficient separation = new SeparationCoefficient(net, assignment);
                report.add("Separation", separation.overallValue());
                SilhouetteCoefficient silhouette = new SilhouetteCoefficient(net, assignment);
                report.add("Silhouette coefficient", silhouette.overallValue());
                CoverageCoefficient coverage = new CoverageCoefficient(net, assignment);
                report.add("Coverage coefficient", coverage.overallValue());
                NetworkUtilities.printReport(report);
            }
            crono.stop();
            System.out.println();
            System.out.println("Time: " + crono);
        }
    }

    private static Network undirected(Network net) {
        int i = 0;
        while (i < net.size()) {
            int degree = net.outDegree(i);
            int j = 0;
            while (j < degree) {
                if (!net.contains(net.outLink(i, j), i)) {
                    net.add(net.outLink(i, j), i);
                }
                ++j;
            }
            ++i;
        }
        return net;
    }

    private static int directedLinks(Network net) {
        int directedLinks = 0;
        int i = 0;
        while (i < net.size()) {
            int degree = net.outDegree(i);
            int j = 0;
            while (j < degree) {
                if (!net.contains(net.outLink(i, j), i)) {
                    ++directedLinks;
                }
                ++j;
            }
            ++i;
        }
        return directedLinks;
    }

    private static int loops(Network net) {
        int loops = 0;
        int i = 0;
        while (i < net.size()) {
            if (net.contains(i, i)) {
                ++loops;
            }
            ++i;
        }
        return loops;
    }

    private static Network withoutLoops(Network net) {
        int i = 0;
        while (i < net.size()) {
            if (net.contains(i, i)) {
                net.remove(i, i);
            }
            ++i;
        }
        return net;
    }
}

