/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.console;

import ikor.parallel.Scheduler;
import ikor.parallel.scheduler.WorkStealingScheduler;
import ikor.util.Benchmark;
import java.io.FileWriter;
import java.io.IOException;
import noesis.Attribute;
import noesis.AttributeNetwork;
import noesis.Network;
import noesis.algorithms.traversal.ConnectedComponents;
import noesis.analysis.NodeScore;
import noesis.analysis.structure.Betweenness;
import noesis.analysis.structure.InDegree;
import noesis.analysis.structure.OutDegree;
import noesis.ui.console.NetworkUtilities;

public class NetworkStats {
    public static void main(String[] args) throws IOException {
        Scheduler.set(new WorkStealingScheduler(16));
        if (args.length == 0) {
            System.err.println("NOESIS Network Statistics:");
            System.err.println();
            System.err.println("  java noesis.ui.console.NetworkStats <file>");
        } else {
            Benchmark crono = new Benchmark();
            crono.start();
            Network net = NetworkUtilities.read(args[0]);
            NetworkUtilities.printNetworkInformation(net);
            ConnectedComponents cc = new ConnectedComponents(net);
            cc.compute();
            System.out.println("- Connected components: " + cc.components());
            OutDegree outDegrees = new OutDegree(net);
            InDegree inDegrees = new InDegree(net);
            outDegrees.compute();
            inDegrees.compute();
            System.out.println("Degree distributions");
            System.out.println("- Out-degrees: " + outDegrees.getResult());
            System.out.println("- In-degrees:  " + inDegrees.getResult());
            if (net instanceof AttributeNetwork) {
                System.out.println("Node of maximum out-degree:");
                NetworkStats.printNode((AttributeNetwork)net, ((NodeScore)outDegrees.getResult()).maxIndex());
                System.out.println("Node of maximum in-degree:");
                NetworkStats.printNode((AttributeNetwork)net, ((NodeScore)inDegrees.getResult()).maxIndex());
            }
            Betweenness betweenness = new Betweenness(net);
            betweenness.compute();
            System.out.println("Betweenness");
            System.out.println(betweenness.getResult());
            if (net instanceof AttributeNetwork) {
                System.out.println("Node of maximum betweenness:");
                NetworkStats.printNode((AttributeNetwork)net, ((NodeScore)betweenness.getResult()).maxIndex());
            }
            crono.stop();
            System.out.println();
            System.out.println("Time: " + crono);
        }
    }

    public static void printNode(AttributeNetwork net, int index) {
        if (index < net.size()) {
            System.out.println("- out-degree: " + net.outDegree(index) + " out-links");
            System.out.println("- in-degree: " + net.inDegree(index) + " in-links");
            int i = 0;
            while (i < net.getNodeAttributeCount()) {
                Attribute attribute = net.getNodeAttribute(i);
                System.out.println("- " + attribute.getID() + ": " + attribute.get(index));
                ++i;
            }
        }
    }

    public static void saveInt(String file, NodeScore metrics) throws IOException {
        FileWriter writer = new FileWriter(file);
        int i = 0;
        while (i < metrics.getNetwork().size()) {
            writer.write("\t" + (int)metrics.get(i));
            ++i;
        }
        writer.close();
    }
}

