/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model;

import ikor.model.Observer;
import ikor.model.Subject;
import ikor.model.ui.Application;
import ikor.model.ui.DatasetSelection;
import ikor.model.ui.DatasetViewer;
import ikor.model.ui.UIModel;
import noesis.AttributeNetwork;
import noesis.ui.model.LinkDataset;
import noesis.ui.model.NetworkModel;

public class LinksetUIModel
extends UIModel {
    private DatasetViewer control;

    public LinksetUIModel(Application app, NetworkModel data) {
        this(app, data, "Network links");
    }

    public LinksetUIModel(Application app, NetworkModel data, String title) {
        super(app, title);
        this.setIcon(app.url("icons/chart.png"));
        LinkDataset dataset = data.getLinkDataset();
        this.control = new DatasetViewer("Link data viewer", dataset.getModel());
        this.add(this.control);
        data.addObserver(new LinksetObserver(data, dataset, this.control));
    }

    @Override
    public void start() {
        DatasetSelection selection = this.control.getSelection();
        if (selection != null) {
            selection.notifyObservers(selection);
        }
    }

    public class LinksetObserver
    implements Observer<AttributeNetwork> {
        private NetworkModel data;
        private LinkDataset dataset;
        private DatasetViewer control;

        public LinksetObserver(NetworkModel data, LinkDataset dataset, DatasetViewer control) {
            this.data = data;
            this.dataset = dataset;
            this.control = control;
        }

        @Override
        public void update(Subject subject, AttributeNetwork network) {
            this.dataset.setNetwork(network);
            this.control.setModel(this.dataset.getModel());
            this.control.clearHeaders();
            int i = 0;
            while (i < this.dataset.getColumnCount()) {
                this.control.addHeader(this.dataset.getName(i));
                ++i;
            }
            this.control.setData(this.dataset);
            DatasetSelection selection = this.data.getLinkSelection();
            this.control.setSelection(selection);
            this.control.notifyObservers(this.dataset);
            selection.notifyObservers(selection);
        }
    }
}

