/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model;

import ikor.model.Subject;
import ikor.model.ui.Application;
import ikor.model.ui.Image;
import ikor.model.ui.Option;
import ikor.model.ui.UIModel;
import noesis.AttributeNetwork;
import noesis.ui.model.NetworkAnalyzerMenu;
import noesis.ui.model.NetworkFigure;
import noesis.ui.model.NetworkModel;
import noesis.ui.model.actions.ExitAction;

public class NetworkAnalyzerUIModel
extends UIModel {
    private NetworkModel model;
    private NetworkFigure figure;
    private NetworkAnalyzerMenu menu;

    public NetworkAnalyzerUIModel(Application app) {
        super(app, "NOESIS Network Analyzer");
        app.addObserver(this);
        this.add(new Option("$exit", new ExitAction(app)));
        this.add(new Image("$icon", app.url("icon.gif")));
        this.add(new Image("$background", app.url("logo.gif")));
        this.model = new NetworkModel((AttributeNetwork)app.get("network"));
        this.figure = new NetworkFigure(this.model);
        this.add(this.figure);
        this.menu = new NetworkAnalyzerMenu(this);
        this.add(this.menu);
    }

    @Override
    public void start() {
        this.figure.hide();
        this.menu.reset();
    }

    @Override
    public void update(Subject subject, String key) {
        if (key != null && key.equals("network")) {
            AttributeNetwork network = (AttributeNetwork)this.get("network");
            if (network != null) {
                this.model.setNetwork(network);
                this.menu.activate();
                this.figure.getRenderer().setNodeRenderer(NetworkFigure.defaultNodeRenderer());
                this.figure.getRenderer().setLinkRenderer(NetworkFigure.defaultLinkRenderer());
                this.figure.render();
                this.figure.show();
            } else {
                this.menu.reset();
            }
        }
    }

    public void reset() {
        this.figure.hide();
        this.menu.reset();
        this.model.setNetwork(null);
    }

    public NetworkModel getModel() {
        return this.model;
    }

    public void setModel(NetworkModel model) {
        this.model = model;
    }

    public NetworkFigure getFigure() {
        return this.figure;
    }

    public void setFigure(NetworkFigure figure) {
        this.figure = figure;
    }
}

