/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model;

import ikor.model.Observer;
import ikor.model.Subject;
import ikor.model.graphics.Drawing;
import ikor.model.graphics.DrawingSelectionListener;
import ikor.model.graphics.DrawingTooltipProvider;
import ikor.model.graphics.DrawingUpdateListener;
import ikor.model.ui.DatasetSelection;
import ikor.model.ui.Figure;
import noesis.Attribute;
import noesis.AttributeNetwork;
import noesis.LinkAttribute;
import noesis.io.graphics.ColorMapLinkRenderer;
import noesis.io.graphics.LinkRenderer;
import noesis.io.graphics.NetworkRenderer;
import noesis.io.graphics.NetworkSelectionRenderer;
import noesis.io.graphics.NodeRenderer;
import noesis.io.graphics.RadialGradientNodeRenderer;
import noesis.ui.model.NetworkModel;

public class NetworkFigure
extends Figure<AttributeNetwork> {
    private NetworkModel data;
    private NetworkRenderer renderer;
    private SelectionObserver selectionObserver;
    public static final int DEFAULT_SIZE = 500;

    public NetworkFigure(NetworkModel data) {
        this.data = data;
        this.renderer = new NetworkSelectionRenderer(data.getNetwork(), data.getNodeSelection(), data.getLinkSelection(), 500, 500);
        this.renderer.setNodeRenderer(NetworkFigure.defaultNodeRenderer());
        this.renderer.setLinkRenderer(NetworkFigure.defaultLinkRenderer());
        this.selectionObserver = new SelectionObserver(this.renderer);
        data.getNodeSelection().addObserver(this.selectionObserver);
        data.getLinkSelection().addObserver(this.selectionObserver);
        this.render();
        this.setTooltipProvider(new NetworkTooltipProvider());
        this.setDraggingListener(new NetworkDraggingListener(this));
        this.setSelectionListener(new NetworkSelectionListener(this));
        this.addObserver(data);
        data.addObserver(this);
    }

    public static NodeRenderer defaultNodeRenderer() {
        return new RadialGradientNodeRenderer();
    }

    public static LinkRenderer defaultLinkRenderer() {
        return new ColorMapLinkRenderer();
    }

    public NetworkModel getData() {
        return this.data;
    }

    public void setData(NetworkModel data) {
        this.data = data;
        super.setModel(data.getNetwork());
    }

    public AttributeNetwork getNetwork() {
        return this.getModel();
    }

    @Override
    public AttributeNetwork getModel() {
        if (this.data != null) {
            return this.data.getNetwork();
        }
        return null;
    }

    public void setNetwork(AttributeNetwork network) {
        this.setModel(network);
    }

    @Override
    public void setModel(AttributeNetwork network) {
        if (network != null) {
            super.setModel(network);
            this.data.setNetwork(network);
            this.renderer.setNetwork(network);
        }
    }

    public NetworkRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(NetworkRenderer renderer) {
        this.renderer = renderer;
    }

    public void refresh() {
        super.setDrawing(this.renderer);
        this.renderer.update();
        this.show();
    }

    public void render() {
        this.renderer.render();
        super.setDrawing(this.renderer);
        this.show();
    }

    public class NetworkDraggingListener
    implements DrawingUpdateListener {
        private NetworkFigure figure;

        public NetworkDraggingListener(NetworkFigure figure) {
            this.figure = figure;
        }

        @Override
        public void update(String id, int x, int y) {
            if (id.startsWith("node")) {
                int node = NetworkFigure.this.renderer.getNodeIndex(id);
                AttributeNetwork net = this.figure.getData().getNetwork();
                Attribute xAttribute = net.getNodeAttribute("x");
                Attribute yAttribute = net.getNodeAttribute("y");
                xAttribute.set(node, (double)x / (double)this.figure.getDrawing().getWidth());
                yAttribute.set(node, 1.0 - (double)y / (double)this.figure.getDrawing().getHeight());
                this.figure.renderer.update(node);
                this.figure.notifyObservers(this.figure.getData().getNetwork());
            }
        }
    }

    public class NetworkSelectionListener
    implements DrawingSelectionListener {
        private Drawing drawing;
        private NetworkModel model;

        public NetworkSelectionListener(NetworkFigure figure) {
            this.drawing = figure.getDrawing();
            this.model = figure.getData();
        }

        @Override
        public void setSelection(String id) {
            this.clearSelection();
            if (this.drawing != null && id != null) {
                if (id.startsWith("node")) {
                    int node = NetworkFigure.this.renderer.getNodeIndex(id);
                    this.model.getNodeSelection().setSelection(node);
                } else if (id.startsWith("link")) {
                    int linkIndex = this.model.getNetwork().index(NetworkFigure.this.renderer.getLinkSourceIndex(id), NetworkFigure.this.renderer.getLinkTargetIndex(id));
                    this.model.getLinkSelection().setSelection(linkIndex);
                }
            }
        }

        @Override
        public void addSelection(String id) {
            if (this.drawing != null && id != null) {
                if (id.startsWith("node")) {
                    int node = NetworkFigure.this.renderer.getNodeIndex(id);
                    this.model.getNodeSelection().addSelection(node);
                } else if (id.startsWith("link")) {
                    int linkIndex = this.model.getNetwork().index(NetworkFigure.this.renderer.getLinkSourceIndex(id), NetworkFigure.this.renderer.getLinkTargetIndex(id));
                    this.model.getLinkSelection().addSelection(linkIndex);
                }
            }
        }

        @Override
        public void clearSelection() {
            this.model.getNodeSelection().clearSelection();
            this.model.getLinkSelection().clearSelection();
        }
    }

    public class NetworkTooltipProvider
    implements DrawingTooltipProvider {
        @Override
        public String get(String id) {
            String tooltip = null;
            int node = NetworkFigure.this.renderer.getNodeIndex(id);
            if (node != -1) {
                tooltip = this.nodeTooltip(node);
            } else {
                int source = NetworkFigure.this.renderer.getLinkSourceIndex(id);
                int target = NetworkFigure.this.renderer.getLinkTargetIndex(id);
                if (source != -1 && target != -1) {
                    tooltip = this.linkTooltip(source, target);
                }
            }
            return tooltip;
        }

        private String nodeTooltip(int node) {
            String tooltip = null;
            AttributeNetwork network = NetworkFigure.this.getNetwork();
            if (network != null) {
                tooltip = "<html><b>" + network.getNodeAttribute("id").get(node) + "</b><br/>";
                int i = 0;
                while (i < network.getNodeAttributeCount()) {
                    Object value;
                    Attribute attribute = network.getNodeAttribute(i);
                    String name = attribute.getID();
                    if (!(name.equals("id") || name.equals("x") || name.equals("y") || (value = attribute.get(node)) == null)) {
                        tooltip = String.valueOf(tooltip) + "- " + attribute.getID() + ": <b>" + value + "</b><br/>";
                    }
                    ++i;
                }
                tooltip = String.valueOf(tooltip) + "</html>";
            }
            return tooltip;
        }

        private String linkTooltip(int source, int target) {
            String tooltip = null;
            AttributeNetwork network = NetworkFigure.this.getNetwork();
            if (network != null) {
                tooltip = "<html>Link";
                Attribute id = network.getNodeAttribute("id");
                if (id != null) {
                    tooltip = String.valueOf(tooltip) + " from <b>" + id.get(source) + "</b>";
                    tooltip = String.valueOf(tooltip) + " to <b>" + id.get(target) + "</b><br/>";
                }
                int i = 0;
                while (i < network.getLinkAttributeCount()) {
                    LinkAttribute attribute = network.getLinkAttribute(i);
                    Object value = attribute.get(source, target);
                    if (value != null) {
                        tooltip = String.valueOf(tooltip) + "- " + attribute.getID() + ": <b>" + value + "</b><br/>";
                    }
                    ++i;
                }
                tooltip = String.valueOf(tooltip) + "</html>";
            }
            return tooltip;
        }
    }

    private class SelectionObserver
    implements Observer<DatasetSelection> {
        private NetworkRenderer renderer;

        public SelectionObserver(NetworkRenderer renderer) {
            this.renderer = renderer;
        }

        @Override
        public void update(Subject<DatasetSelection> subject, DatasetSelection object) {
            this.renderer.update();
        }
    }
}

