/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model;

import ikor.model.Subject;
import ikor.model.ui.DatasetSelection;
import noesis.AttributeNetwork;
import noesis.ui.model.LinkDataset;
import noesis.ui.model.NodeDataset;

public class NetworkModel
extends Subject<AttributeNetwork> {
    private AttributeNetwork network;
    private DatasetSelection nodeSelection;
    private DatasetSelection linkSelection;
    private NodeDataset nodeDataset;
    private LinkDataset linkDataset;
    private boolean updating = false;

    public NetworkModel(AttributeNetwork network) {
        this.network = network;
        this.nodeSelection = new ObservedDatasetSelection(this);
        this.linkSelection = new ObservedDatasetSelection(this);
        this.nodeDataset = new NodeDataset();
        this.linkDataset = new LinkDataset();
    }

    public DatasetSelection getNodeSelection() {
        return this.nodeSelection;
    }

    public DatasetSelection getLinkSelection() {
        return this.linkSelection;
    }

    public NodeDataset getNodeDataset() {
        return this.nodeDataset;
    }

    public LinkDataset getLinkDataset() {
        return this.linkDataset;
    }

    public AttributeNetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(AttributeNetwork network) {
        if (this.network != network) {
            this.nodeSelection.clearSelection();
            this.linkSelection.clearSelection();
            this.network = network;
        }
        this.notifyObservers(network);
    }

    @Override
    public void update(Subject subject, AttributeNetwork object) {
        if (!this.updating) {
            try {
                this.updating = true;
                if (object != null) {
                    this.setNetwork(object);
                } else {
                    this.notifyObservers(this.network);
                }
            }
            finally {
                this.updating = false;
            }
        }
    }

    private static class ObservedDatasetSelection
    extends DatasetSelection {
        private NetworkModel model;

        public ObservedDatasetSelection(NetworkModel model) {
            this.model = model;
        }

        @Override
        public void update(Subject subject, DatasetSelection object) {
            super.update(subject, object);
            this.model.notifyObservers(this.model.network);
        }
    }
}

