/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model;

import ikor.model.Observer;
import ikor.model.Subject;
import ikor.model.graphics.colors.JetColorMap;
import ikor.model.ui.Application;
import ikor.model.ui.Editor;
import ikor.model.ui.Option;
import ikor.model.ui.Selector;
import ikor.model.ui.UIModel;
import noesis.AttributeNetwork;
import noesis.ui.model.NetworkFigure;
import noesis.ui.model.actions.NodeAttributeColorAction;
import noesis.ui.model.actions.NodeAttributePositionAction;
import noesis.ui.model.actions.NodeAttributeSizeAction;

public class NodeAttributesUIModel
extends UIModel {
    NetworkFigure figure;
    Selector attributes;
    UIModel buttons;

    public NodeAttributesUIModel(Application app, NetworkFigure figure) {
        super(app, "Node attributes...");
        this.setIcon(app.url("icon.gif"));
        this.figure = figure;
        UIModel panel = new UIModel(app, "Container panel");
        panel.setAlignment(UIModel.Alignment.TRAILING);
        this.attributes = new Selector();
        panel.add(this.attributes);
        this.buttons = new UIModel(app, "Button bar");
        panel.add(this.buttons);
        this.add(panel);
        this.buttons.setAlignment(UIModel.Alignment.ADJUST);
        Editor<Boolean> logScale = new Editor<Boolean>("Logarithmic scale", Boolean.class);
        this.buttons.add(logScale);
        Option color = new Option("Adjust node colors");
        color.setIcon(app.url("icon.gif"));
        color.setAction(new NodeAttributeColorAction(app, figure, this.attributes, logScale, new JetColorMap(256)));
        this.buttons.add(color);
        Option size = new Option("Adjust node sizes");
        size.setIcon(app.url("icon.gif"));
        size.setAction(new NodeAttributeSizeAction(app, figure, this.attributes, logScale));
        this.buttons.add(size);
        Option x = new Option("Adjust X coordinates");
        x.setIcon(app.url("icon.gif"));
        x.setAction(new NodeAttributePositionAction(app, figure, this.attributes, logScale, NodeAttributePositionAction.Axis.X));
        this.buttons.add(x);
        Option y = new Option("Adjust Y coordinates");
        y.setIcon(app.url("icon.gif"));
        y.setAction(new NodeAttributePositionAction(app, figure, this.attributes, logScale, NodeAttributePositionAction.Axis.Y));
        this.buttons.add(y);
        figure.addObserver(new AttributeObserver(figure, this.attributes));
    }

    public class AttributeObserver
    implements Observer<AttributeNetwork> {
        private NetworkFigure figure;
        private Selector attributes;

        public AttributeObserver(NetworkFigure figure, Selector control) {
            this.figure = figure;
            this.attributes = control;
        }

        @Override
        public void update(Subject subject, AttributeNetwork object) {
            Application app = NodeAttributesUIModel.this.getApplication();
            AttributeNetwork network = this.figure.getNetwork();
            if (network == null) {
                this.attributes.clear();
            } else if (network.getNodeAttributeCount() != this.attributes.getOptions().size()) {
                this.attributes.clear();
                this.attributes.setMultipleSelection(false);
                int i = 0;
                while (i < network.getNodeAttributeCount()) {
                    Option option = new Option(network.getNodeAttribute(i).getID());
                    option.setIcon(app.url("icons/kiviat.png"));
                    this.attributes.add(option);
                    ++i;
                }
            }
        }
    }
}

