/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model;

import ikor.model.data.IntegerModel;
import ikor.model.data.RealModel;
import ikor.model.ui.Action;
import ikor.model.ui.Application;
import ikor.model.ui.Editor;
import ikor.model.ui.Option;
import ikor.model.ui.UIModel;
import noesis.ParameterMetadata;
import noesis.analysis.NodeScoreTask;
import noesis.ui.model.NetworkModel;
import noesis.ui.model.actions.NodeScoreAction;

public class NodeScoreUIModel
extends UIModel {
    private ParameterMetadata[] parameters;
    private Editor[] editors;
    private NodeScoreAction action;
    private NodeScoreTask task;

    public NodeScoreUIModel(Application app, NetworkModel networkModel, NodeScoreAction action, NodeScoreTask task) {
        super(app, String.valueOf(task.getDescription()) + " parameters");
        this.setIcon(app.url("icon.gif"));
        this.action = action;
        this.task = task;
        this.parameters = task.getParameters();
        this.editors = new Editor[this.parameters.length];
        int i = 0;
        while (i < this.parameters.length) {
            Editor<Number> editor;
            ParameterMetadata parameter = this.parameters[i];
            if (parameter.getModel() instanceof RealModel) {
                editor = new Editor<Number>(parameter.getDescription(), parameter.getModel());
                editor.setData(parameter.getDefaultValue());
            } else {
                editor = new Editor(parameter.getDescription(), parameter.getModel());
                editor.setData((int)parameter.getDefaultValue());
            }
            editor.setIcon(app.url("icons/calculator.png"));
            this.editors[i] = editor;
            this.add(editor);
            ++i;
        }
        Option ok = new Option("Compute node score");
        ok.setIcon(app.url("icon.gif"));
        ok.setAction(new ComputeNodeScoreAction(this, networkModel));
        this.add(ok);
    }

    public class ComputeNodeScoreAction
    extends Action {
        private NodeScoreUIModel ui;
        private NetworkModel networkModel;

        public ComputeNodeScoreAction(NodeScoreUIModel ui, NetworkModel networkModel) {
            this.ui = ui;
            this.networkModel = networkModel;
        }

        @Override
        public void run() {
            int i = 0;
            while (i < NodeScoreUIModel.this.parameters.length) {
                if (NodeScoreUIModel.this.parameters[i].getModel() instanceof IntegerModel) {
                    NodeScoreUIModel.this.parameters[i].set(NodeScoreUIModel.this.task, ((Integer)NodeScoreUIModel.this.editors[i].getData()).doubleValue());
                } else {
                    NodeScoreUIModel.this.parameters[i].set(NodeScoreUIModel.this.task, (Double)NodeScoreUIModel.this.editors[i].getData());
                }
                ++i;
            }
            this.ui.exit();
            NodeScoreUIModel.this.action.computeScore(this.networkModel.getNetwork(), NodeScoreUIModel.this.task);
        }
    }
}

