/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model;

import ikor.model.Observer;
import ikor.model.Subject;
import ikor.model.ui.Application;
import ikor.model.ui.DatasetSelection;
import ikor.model.ui.DatasetViewer;
import ikor.model.ui.UIModel;
import noesis.AttributeNetwork;
import noesis.ui.model.NetworkModel;
import noesis.ui.model.NodeDataset;

public class NodesetUIModel
extends UIModel {
    private DatasetViewer control;

    public NodesetUIModel(Application app, NetworkModel data) {
        super(app, "Network nodes");
        this.setIcon(app.url("icons/chart.png"));
        NodeDataset dataset = data.getNodeDataset();
        this.control = new DatasetViewer("Node data viewer", dataset.getModel());
        this.add(this.control);
        data.addObserver(new NodesetObserver(data, dataset, this.control));
    }

    @Override
    public void start() {
        DatasetSelection selection = this.control.getSelection();
        if (selection != null) {
            selection.notifyObservers(selection);
        }
    }

    public class NodesetObserver
    implements Observer<AttributeNetwork> {
        private NetworkModel data;
        private NodeDataset dataset;
        private DatasetViewer control;

        public NodesetObserver(NetworkModel data, NodeDataset dataset, DatasetViewer control) {
            this.data = data;
            this.dataset = dataset;
            this.control = control;
        }

        @Override
        public void update(Subject subject, AttributeNetwork network) {
            this.dataset.setNetwork(network);
            this.control.setModel(this.dataset.getModel());
            this.control.clearHeaders();
            int i = 0;
            while (i < this.dataset.getColumnCount()) {
                this.control.addHeader(this.dataset.getName(i));
                ++i;
            }
            this.control.setData(this.dataset);
            DatasetSelection selection = this.data.getNodeSelection();
            this.control.setSelection(selection);
            this.control.notifyObservers(this.dataset);
            selection.notifyObservers(selection);
        }
    }
}

