/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.actions;

import ikor.model.data.RealModel;
import ikor.model.ui.Action;
import ikor.model.ui.File;
import ikor.util.log.Log;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import noesis.ArrayNetwork;
import noesis.Attribute;
import noesis.AttributeNetwork;
import noesis.Network;
import noesis.algorithms.visualization.NormalizedLayout;
import noesis.algorithms.visualization.RandomLayout;
import noesis.io.ASCIINetworkReader;
import noesis.io.GDFNetworkReader;
import noesis.io.GMLNetworkReader;
import noesis.io.GraphMLNetworkReader;
import noesis.io.NetworkReader;
import noesis.io.PajekNetworkReader;
import noesis.io.SNAPGZNetworkReader;
import noesis.io.SNAPNetworkReader;
import noesis.ui.model.NetworkAnalyzerUIModel;

public class AnalyzerOpenAction
extends Action {
    private NetworkAnalyzerUIModel ui;
    private File file;

    public AnalyzerOpenAction(NetworkAnalyzerUIModel ui) {
        this.ui = ui;
        this.file = new File(ui.getApplication(), "Open network...", "Open", new FileCommandAction());
    }

    @Override
    public void run() {
        this.file.getApplication().run(this.file);
    }

    public class FileCommandAction
    extends Action {
        @Override
        public void run() {
            String filename = AnalyzerOpenAction.this.file.getUrl();
            if (filename != null) {
                try {
                    AttributeNetwork net = this.read(filename);
                    Attribute id = net.getNodeAttribute("id");
                    if (id == null) {
                        id = new Attribute("id");
                        net.addNodeAttribute(id);
                        int i = 0;
                        while (i < net.size()) {
                            id.set(i, "" + (i + 1));
                            ++i;
                        }
                    }
                    Attribute x = net.getNodeAttribute("x");
                    Attribute y = net.getNodeAttribute("y");
                    if (x == null || y == null) {
                        RealModel coordinateModel = new RealModel();
                        coordinateModel.setMinimumValue(0.0);
                        coordinateModel.setMaximumValue(1.0);
                        x = new Attribute("x", coordinateModel);
                        y = new Attribute("y", coordinateModel);
                        net.addNodeAttribute(x);
                        net.addNodeAttribute(y);
                        RandomLayout display = new RandomLayout();
                        display.layout(net);
                    } else {
                        NormalizedLayout normalize = new NormalizedLayout();
                        normalize.layout(net);
                    }
                    AnalyzerOpenAction.this.ui.set("network", net);
                }
                catch (Exception error) {
                    Log.error("Unable to load network - " + error);
                }
            }
        }

        private AttributeNetwork read(String url) {
            AttributeNetwork net = null;
            try {
                NetworkReader reader;
                if (url.endsWith(".net")) {
                    reader = new PajekNetworkReader(new FileReader(url));
                } else if (url.endsWith(".dat")) {
                    reader = new ASCIINetworkReader(new FileReader(url));
                } else if (url.endsWith(".txt")) {
                    reader = new SNAPNetworkReader(new FileReader(url));
                } else if (url.endsWith(".gz")) {
                    reader = new SNAPGZNetworkReader(new FileInputStream(url));
                } else if (url.endsWith(".gml")) {
                    reader = new GMLNetworkReader(new FileReader(url));
                } else if (url.endsWith(".graphml")) {
                    reader = new GraphMLNetworkReader(new FileInputStream(url));
                } else if (url.endsWith(".gdf")) {
                    reader = new GDFNetworkReader(new FileReader(url));
                } else {
                    throw new IOException("Unknown network file format.");
                }
                reader.setType(ArrayNetwork.class);
                net = reader.read();
                reader.close();
            }
            catch (FileNotFoundException fnfe) {
                Log.error("File not found - " + url);
            }
            catch (IOException ioe) {
                Log.error("IO error - " + ioe);
            }
            if (net != null) {
                if (net.getID() != null) {
                    AnalyzerOpenAction.this.ui.message("Network '" + net.getID() + "' loaded with " + net.size() + " nodes and " + ((Network)net).links() + " links.");
                } else {
                    AnalyzerOpenAction.this.ui.message("Network loaded with " + net.size() + " nodes and " + ((Network)net).links() + " links.");
                }
                if (!(net instanceof AttributeNetwork)) {
                    net = new AttributeNetwork(net);
                }
            } else {
                AnalyzerOpenAction.this.ui.message("Unable to read network, sorry :-(");
            }
            return net;
        }
    }
}

