/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.actions;

import ikor.model.ui.Action;
import ikor.util.log.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import noesis.AttributeNetwork;
import noesis.io.GDFNetworkWriter;
import noesis.io.GMLNetworkWriter;
import noesis.io.GraphMLNetworkWriter;
import noesis.io.NetworkWriter;
import noesis.io.PajekNetworkWriter;
import noesis.io.graphics.NetworkImageWriter;
import noesis.ui.model.NetworkAnalyzerUIModel;

public class AnalyzerSaveAction
extends Action {
    private NetworkAnalyzerUIModel ui;
    private String format;
    private ikor.model.ui.File file;

    public AnalyzerSaveAction(NetworkAnalyzerUIModel ui, String format) {
        this.ui = ui;
        this.format = format;
        this.file = new ikor.model.ui.File(ui.getApplication(), "Save network...", "Save", new FileCommandAction());
    }

    @Override
    public void run() {
        this.file.setUrl("network." + this.format);
        this.file.getApplication().run(this.file);
    }

    public class FileCommandAction
    extends Action {
        @Override
        public void run() {
            String filename = AnalyzerSaveAction.this.file.getUrl();
            if (!this.checkFilename(filename)) {
                filename = null;
            }
            if (filename != null) {
                AttributeNetwork net = (AttributeNetwork)AnalyzerSaveAction.this.ui.get("network");
                try {
                    NetworkWriter writer;
                    if (AnalyzerSaveAction.this.format.equals("gdf")) {
                        writer = new GDFNetworkWriter(new FileWriter(filename));
                    } else if (AnalyzerSaveAction.this.format.equals("gml")) {
                        writer = new GMLNetworkWriter(new FileWriter(filename));
                    } else if (AnalyzerSaveAction.this.format.equals("graphml")) {
                        writer = new GraphMLNetworkWriter(new FileWriter(filename));
                    } else if (AnalyzerSaveAction.this.format.equals("pajek")) {
                        writer = new PajekNetworkWriter(new FileWriter(filename));
                    } else if (AnalyzerSaveAction.this.format.equals("png")) {
                        writer = new NetworkImageWriter(new FileOutputStream(filename), AnalyzerSaveAction.this.ui.getFigure().getRenderer(), "png");
                    } else if (AnalyzerSaveAction.this.format.equals("jpg")) {
                        writer = new NetworkImageWriter(new FileOutputStream(filename), AnalyzerSaveAction.this.ui.getFigure().getRenderer(), "jpg");
                    } else if (AnalyzerSaveAction.this.format.equals("svg")) {
                        writer = new NetworkImageWriter(new FileOutputStream(filename), AnalyzerSaveAction.this.ui.getFigure().getRenderer(), "svg");
                    } else {
                        throw new IOException("Unknown output network file format.");
                    }
                    if (writer != null) {
                        writer.write(net);
                        writer.close();
                    }
                }
                catch (IOException ioe) {
                    Log.error("IO error - " + ioe);
                }
            }
        }

        private boolean checkFilename(String filename) {
            if (filename != null) {
                File file = new File(filename);
                if (file.exists()) {
                    return AnalyzerSaveAction.this.ui.confirm("Overwrite existing file?");
                }
                return true;
            }
            return false;
        }
    }
}

