/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.actions;

import ikor.model.graphics.colors.ColorMap;
import ikor.model.graphics.colors.JetColorMap;
import ikor.model.ui.Application;
import ikor.util.log.Log;
import java.lang.reflect.Constructor;
import noesis.Attribute;
import noesis.AttributeNetwork;
import noesis.Network;
import noesis.algorithms.communities.CommunityDetector;
import noesis.algorithms.communities.CommunityDetectorTask;
import noesis.analysis.NodeScore;
import noesis.analysis.NodeScoreTask;
import noesis.analysis.structure.communities.CohesionCoefficient;
import noesis.analysis.structure.communities.CoverageCoefficient;
import noesis.analysis.structure.communities.ModularityCoefficient;
import noesis.analysis.structure.communities.SeparationCoefficient;
import noesis.analysis.structure.communities.SilhouetteCoefficient;
import noesis.network.attribute.NumericalNodeAttributeIndexer;
import noesis.ui.model.NetworkFigure;
import noesis.ui.model.NetworkModel;
import noesis.ui.model.actions.ForwardAction;
import noesis.ui.model.actions.NodeScoreAction;
import noesis.ui.model.data.Report;
import noesis.ui.model.data.ReportUIModel;

public class CommunityDetectionAction
extends NodeScoreAction {
    private Class detector;
    private CommunityDetectorTask task;
    private NetworkFigure figure;

    public CommunityDetectionAction(Application application, NetworkFigure figure, NetworkModel model, Class detector) {
        super(application, model, detector);
        this.figure = figure;
        this.detector = detector;
    }

    @Override
    public NodeScoreTask instantiateTask(Network network) {
        try {
            network = this.undirected(network);
            Constructor constructor = this.detector.getConstructor(AttributeNetwork.class);
            this.task = new CommunityDetectorTask((CommunityDetector)constructor.newInstance(network), (AttributeNetwork)network);
        }
        catch (Exception error) {
            Log.error("Community detection algorithm: Unable to instantiate " + this.detector);
        }
        return this.task;
    }

    private Network undirected(Network net) {
        int i = 0;
        while (i < net.size()) {
            int degree = net.outDegree(i);
            int j = 0;
            while (j < degree) {
                if (!net.contains(net.outLink(i, j), i)) {
                    net.add(net.outLink(i, j), i);
                }
                ++j;
            }
            ++i;
        }
        return net;
    }

    @Override
    public void run() {
        super.run();
        Attribute attribute = ((AttributeNetwork)this.getNetwork()).getNodeAttribute(this.task.getName());
        JetColorMap map = new JetColorMap(256);
        NumericalNodeAttributeIndexer indexer = new NumericalNodeAttributeIndexer(attribute, ((ColorMap)map).size());
        this.figure.getRenderer().getNodeRenderer().setColorMap(map);
        this.figure.getRenderer().getNodeRenderer().setColorIndexer(indexer);
        this.figure.refresh();
        this.generateReport();
    }

    private void generateReport() {
        AttributeNetwork network = (AttributeNetwork)this.getNetwork();
        NodeScore assignment = (NodeScore)this.task.getResult();
        Report report = new Report();
        report.add("Number of nodes", network.nodes());
        report.add("Number of communities", assignment.max() - assignment.min() + 1.0);
        ModularityCoefficient modularity = new ModularityCoefficient(network, assignment);
        report.add("Modularity", modularity.overallValue());
        CohesionCoefficient cohesion = new CohesionCoefficient(network, assignment);
        report.add("Cohesion", cohesion.overallValue());
        SeparationCoefficient separation = new SeparationCoefficient(network, assignment);
        report.add("Separation", separation.overallValue());
        SilhouetteCoefficient silhouette = new SilhouetteCoefficient(network, assignment);
        report.add("Silhouette coefficient", silhouette.overallValue());
        CoverageCoefficient coverage = new CoverageCoefficient(network, assignment);
        report.add("Coverage coefficient", coverage.overallValue());
        ReportUIModel statsUI = new ReportUIModel(this.getApplication(), "Clustering results", report);
        ForwardAction forward = new ForwardAction(statsUI);
        forward.run();
    }
}

