/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.actions;

import ikor.model.graphics.colors.ColorMap;
import ikor.model.ui.Application;
import ikor.model.ui.Editor;
import ikor.model.ui.Selector;
import ikor.util.indexer.Indexer;
import noesis.AttributeNetwork;
import noesis.LinkAttribute;
import noesis.ui.model.NetworkFigure;
import noesis.ui.model.actions.LinkAttributeAction;

public class LinkAttributeColorAction
extends LinkAttributeAction {
    private Application application;
    private NetworkFigure figure;
    private Selector attributes;
    private Editor<Boolean> logScale;
    private ColorMap map;

    public LinkAttributeColorAction(Application application, NetworkFigure figure, Selector attributes, Editor<Boolean> logScale, ColorMap map) {
        this.application = application;
        this.figure = figure;
        this.attributes = attributes;
        this.logScale = logScale;
        this.map = map;
    }

    @Override
    public void run() {
        AttributeNetwork network = (AttributeNetwork)this.application.get("network");
        if (network != null) {
            String id = this.getSelectedAttributeID(this.attributes);
            if (id == null) {
                this.application.message("Please, choose an attribute to adjust link colors.");
            } else {
                LinkAttribute attribute = network.getLinkAttribute(id);
                Indexer indexer = this.createIndexer(attribute, this.map.size(), this.isLogarithmicScale(this.logScale));
                this.figure.getRenderer().getLinkRenderer().setColorMap(this.map);
                this.figure.getRenderer().getLinkRenderer().setColorIndexer(indexer);
                this.figure.refresh();
            }
        }
    }
}

