/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.actions;

import ikor.math.Matrix;
import ikor.model.ui.Action;
import ikor.model.ui.Application;
import ikor.model.ui.Editor;
import ikor.model.ui.UIModel;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import noesis.Attribute;
import noesis.AttributeNetwork;
import noesis.LinkAttribute;
import noesis.Network;
import noesis.analysis.structure.links.prediction.NodePairMeasureTask;
import noesis.ui.model.LinksetUIModel;
import noesis.ui.model.NetworkModel;
import noesis.ui.model.actions.ForwardAction;

public class LinkPredictionAction
extends Action {
    private Application app;
    private Class methodClass;
    private Optional<UIModel> ui;
    private Optional<List<Editor>> editors;

    public LinkPredictionAction(Application app, Optional<UIModel> ui, NetworkModel model, Class methodClass, Optional<List<Editor>> editors) {
        this.app = app;
        this.ui = ui;
        this.methodClass = methodClass;
        this.editors = editors;
    }

    @Override
    public void run() {
        AttributeNetwork network = (AttributeNetwork)this.app.get("network");
        AttributeNetwork fixedNetwork = this.createAugmentedNetwork(network);
        Stream<Object> valueStream = Stream.of(fixedNetwork);
        Stream<Class<Network>> classesStream = Stream.of(Network.class);
        if (this.editors.isPresent()) {
            valueStream = Stream.concat(valueStream, this.editors.get().stream().map(e -> e.getData()));
            classesStream = Stream.concat(classesStream, this.editors.get().stream().map(e -> e.getData().getClass()));
        }
        Object[] values = valueStream.toArray(Object[]::new);
        Class[] classes = (Class[])classesStream.toArray(Class[]::new);
        try {
            NodePairMeasureTask method = (NodePairMeasureTask)this.methodClass.getConstructor(classes).newInstance(values);
            int numNodes = network.nodes();
            AttributeNetwork predictionNet = new AttributeNetwork();
            predictionNet.setSize(numNodes);
            Attribute idAttribute = new Attribute("id");
            predictionNet.addNodeAttribute(idAttribute);
            int i = 0;
            while (i < predictionNet.size()) {
                idAttribute.set(i, network.getNodeAttribute("id").get(i));
                ++i;
            }
            LinkAttribute<Double> scoreAttribute = new LinkAttribute<Double>(predictionNet, method.getName());
            predictionNet.addLinkAttribute(scoreAttribute);
            Matrix scores = method.call();
            int i2 = 0;
            while (i2 < numNodes) {
                int j = i2 + 1;
                while (j < numNodes) {
                    double score = scores.get(i2, j);
                    if (score > 0.0 && !network.contains(i2, j)) {
                        predictionNet.add(i2, j);
                        scoreAttribute.set(i2, j, score);
                    }
                    ++j;
                }
                ++i2;
            }
            NetworkModel networkModel = new NetworkModel(predictionNet);
            LinksetUIModel linksetModel = new LinksetUIModel(this.app, networkModel, "Predicted links - " + method.getDescription());
            networkModel.notifyObservers(predictionNet);
            ForwardAction forward = new ForwardAction(linksetModel);
            forward.run();
            if (this.ui.isPresent()) {
                this.ui.get().exit();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private AttributeNetwork createAugmentedNetwork(AttributeNetwork network) {
        AttributeNetwork undirectedNetwork = new AttributeNetwork();
        undirectedNetwork.setSize(network.size());
        int node = 0;
        while (node < network.size()) {
            int link = 0;
            while (link < network.outDegree(node)) {
                int target = network.outLink(node, link);
                if (!undirectedNetwork.contains(node, target)) {
                    undirectedNetwork.add2(node, target);
                }
                ++link;
            }
            ++node;
        }
        return undirectedNetwork;
    }
}

