/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.actions;

import ikor.model.data.IntegerModel;
import ikor.model.ui.Action;
import ikor.model.ui.Application;
import ikor.util.log.Log;
import java.lang.reflect.Constructor;
import noesis.AttributeNetwork;
import noesis.LinkAttribute;
import noesis.Network;
import noesis.analysis.LinkScore;
import noesis.analysis.LinkScoreTask;
import noesis.ui.model.NetworkModel;
import noesis.ui.model.actions.ForwardAction;
import noesis.ui.model.data.VectorUIModel;

public class LinkScoreAction
extends Action {
    private Application application;
    private NetworkModel model;
    private Class measureClass;

    public LinkScoreAction(Application application, NetworkModel model, Class metric) {
        this.application = application;
        this.model = model;
        this.measureClass = metric;
    }

    public LinkScoreTask instantiateTask(Network network) {
        LinkScoreTask task = null;
        try {
            Constructor constructor = this.measureClass.getConstructor(Network.class);
            task = (LinkScoreTask)constructor.newInstance(network);
        }
        catch (Exception error) {
            Log.error("LinkMeasure: Unable to instantiate " + this.measureClass);
        }
        return task;
    }

    @Override
    public void run() {
        LinkScoreTask task;
        AttributeNetwork network = this.model.getNetwork();
        if (network != null && (task = this.instantiateTask(network)) != null) {
            LinkScore metrics = (LinkScore)task.getResult();
            String id = metrics.getName();
            LinkAttribute<Number> attribute = network.getLinkAttribute(id);
            if (attribute == null) {
                attribute = new LinkAttribute<Number>(network, metrics.getName(), metrics.getModel());
                network.addLinkAttribute(attribute);
            }
            int i = 0;
            while (i < network.links()) {
                if (metrics.getModel() instanceof IntegerModel) {
                    attribute.set(i, (int)metrics.get(i));
                } else {
                    attribute.set(i, metrics.get(i));
                }
                ++i;
            }
            this.model.setNetwork(network);
            VectorUIModel resultsUI = new VectorUIModel(this.application, metrics.getDescription(), metrics);
            ForwardAction forward = new ForwardAction(resultsUI);
            forward.run();
        }
    }
}

