/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.actions;

import ikor.model.data.IntegerModel;
import ikor.model.ui.Action;
import ikor.model.ui.Application;
import ikor.model.ui.Editor;
import ikor.model.ui.UIModel;
import ikor.util.log.Log;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import noesis.AttributeNetwork;
import noesis.LinkAttribute;
import noesis.Network;
import noesis.analysis.LinkScore;
import noesis.analysis.LinkScoreTask;
import noesis.analysis.structure.links.prediction.NodePairMeasureTask;
import noesis.analysis.structure.links.scoring.LinkScorer;
import noesis.ui.model.LinksetUIModel;
import noesis.ui.model.NetworkModel;
import noesis.ui.model.actions.ForwardAction;
import noesis.ui.model.data.VectorUIModel;

public class LinkScoringAction
extends Action {
    private Application application;
    private NetworkModel model;
    private Class measureClass;
    private Optional<UIModel> ui;
    private Optional<List<Editor>> editors;

    public LinkScoringAction(Application application, Optional<UIModel> ui, NetworkModel model, Class metric, Optional<List<Editor>> editors) {
        this.application = application;
        this.ui = ui;
        this.model = model;
        this.measureClass = metric;
        this.editors = editors;
    }

    public LinkScoreTask instantiateTask(Network network, Optional<List<Editor>> editors) {
        LinkScorer task = null;
        try {
            Stream<Object> valueStream = Stream.of(network);
            Stream<Class<Network>> classesStream = Stream.of(Network.class);
            if (editors.isPresent()) {
                valueStream = Stream.concat(valueStream, editors.get().stream().map(e -> e.getData()));
                classesStream = Stream.concat(classesStream, editors.get().stream().map(e -> e.getData().getClass()));
            }
            Object[] values = valueStream.toArray(Object[]::new);
            Class[] classes = (Class[])classesStream.toArray(Class[]::new);
            Constructor constructor = this.measureClass.getConstructor(classes);
            NodePairMeasureTask scoreTask = (NodePairMeasureTask)constructor.newInstance(values);
            task = new LinkScorer(network, scoreTask);
        }
        catch (Exception error) {
            Log.error("LinkMeasure: Unable to instantiate " + this.measureClass);
        }
        return task;
    }

    @Override
    public void run() {
        LinkScoreTask task;
        AttributeNetwork network = this.model.getNetwork();
        if (network != null && (task = this.instantiateTask(network, this.editors)) != null) {
            LinkScore metrics = (LinkScore)task.getResult();
            String id = metrics.getName();
            LinkAttribute<Number> attribute = network.getLinkAttribute(id);
            if (attribute == null) {
                attribute = new LinkAttribute<Number>(network, metrics.getName(), metrics.getModel());
                network.addLinkAttribute(attribute);
            }
            int i = 0;
            while (i < network.links()) {
                if (metrics.getModel() instanceof IntegerModel) {
                    attribute.set(i, (int)metrics.get(i));
                } else {
                    attribute.set(i, metrics.get(i));
                }
                ++i;
            }
            this.model.setNetwork(network);
            VectorUIModel resultsUI = new VectorUIModel(this.application, metrics.getDescription(), metrics);
            ForwardAction forward = new ForwardAction(resultsUI);
            forward.run();
            LinksetUIModel linksetModel = new LinksetUIModel(this.application, this.model, metrics.getDescription());
            this.model.notifyObservers(network);
            ForwardAction data = new ForwardAction(linksetModel);
            data.run();
            if (this.ui.isPresent()) {
                this.ui.get().exit();
            }
        }
    }
}

