/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.actions;

import ikor.model.graphics.colors.ColorMap;
import ikor.model.ui.Action;
import ikor.model.ui.Application;
import ikor.util.log.Log;
import noesis.AttributeNetwork;
import noesis.io.graphics.ColorMapLinkRenderer;
import noesis.io.graphics.LinkRenderer;
import noesis.ui.model.NetworkFigure;

public class LinkStyleAction
extends Action {
    private Application application;
    private NetworkFigure figure;
    private Class renderer;
    private ColorMap map;

    public LinkStyleAction(Application application, NetworkFigure figure, Class renderer) {
        this.application = application;
        this.figure = figure;
        this.renderer = renderer;
    }

    public LinkStyleAction(Application application, NetworkFigure figure, ColorMap map) {
        this.application = application;
        this.figure = figure;
        this.renderer = null;
        this.map = map;
    }

    public LinkRenderer instantiateLinkRenderer(Class type) {
        LinkRenderer renderer = null;
        try {
            renderer = (LinkRenderer)type.newInstance();
        }
        catch (Exception error) {
            Log.error("Unable to instantiate link renderer from " + type);
            renderer = new ColorMapLinkRenderer();
        }
        return renderer;
    }

    @Override
    public void run() {
        AttributeNetwork network = (AttributeNetwork)this.application.get("network");
        if (network != null) {
            if (this.renderer != null) {
                LinkRenderer linkRenderer = this.instantiateLinkRenderer(this.renderer);
                LinkRenderer figureRenderer = this.figure.getRenderer().getLinkRenderer();
                linkRenderer.setWidth(figureRenderer.getWidth());
                linkRenderer.setColorMap(figureRenderer.getColorMap());
                linkRenderer.setWidthIndexer(figureRenderer.getWidthIndexer());
                linkRenderer.setColorIndexer(figureRenderer.getColorIndexer());
                this.figure.getRenderer().setLinkRenderer(linkRenderer);
            }
            if (this.map != null) {
                this.figure.getRenderer().getLinkRenderer().setColorMap(this.map);
            }
            this.figure.render();
        }
    }
}

