/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.actions;

import ikor.model.graphics.colors.ColorMap;
import ikor.model.ui.Application;
import ikor.model.ui.Editor;
import ikor.model.ui.Selector;
import ikor.util.indexer.Indexer;
import noesis.Attribute;
import noesis.AttributeNetwork;
import noesis.ui.model.NetworkFigure;
import noesis.ui.model.actions.NodeAttributeAction;

public class NodeAttributeColorAction
extends NodeAttributeAction {
    private Application application;
    private NetworkFigure figure;
    private Selector attributes;
    private Editor<Boolean> logScale;
    private ColorMap map;

    public NodeAttributeColorAction(Application application, NetworkFigure figure, Selector attributes, Editor<Boolean> logScale, ColorMap map) {
        this.application = application;
        this.figure = figure;
        this.attributes = attributes;
        this.logScale = logScale;
        this.map = map;
    }

    @Override
    public void run() {
        AttributeNetwork network = (AttributeNetwork)this.application.get("network");
        if (network != null) {
            String id = this.getSelectedAttributeID(this.attributes);
            if (id == null) {
                this.application.message("Please, choose an attribute to adjust node colors.");
            } else {
                Attribute attribute = network.getNodeAttribute(id);
                Indexer indexer = this.createIndexer(attribute, this.map.size(), this.isLogarithmicScale(this.logScale));
                this.figure.getRenderer().getNodeRenderer().setColorMap(this.map);
                this.figure.getRenderer().getNodeRenderer().setColorIndexer(indexer);
                this.figure.refresh();
            }
        }
    }
}

