/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.actions;

import ikor.model.ui.Application;
import ikor.model.ui.Editor;
import ikor.model.ui.Selector;
import ikor.util.indexer.Indexer;
import noesis.Attribute;
import noesis.AttributeNetwork;
import noesis.ui.model.NetworkFigure;
import noesis.ui.model.actions.NodeAttributeAction;

public class NodeAttributePositionAction
extends NodeAttributeAction {
    private Application application;
    private Selector attributes;
    private Editor<Boolean> logScale;
    private NetworkFigure figure;
    private Axis axis;
    public static final int DEFAULT_INDEX_SIZE = 2048;

    public NodeAttributePositionAction(Application application, NetworkFigure figure, Selector attributes, Editor<Boolean> logScale, Axis axis) {
        this.application = application;
        this.figure = figure;
        this.attributes = attributes;
        this.logScale = logScale;
        this.axis = axis;
    }

    @Override
    public void run() {
        AttributeNetwork network = (AttributeNetwork)this.application.get("network");
        if (network != null) {
            String id = this.getSelectedAttributeID(this.attributes);
            if (id == null) {
                this.application.message("Please, choose an attribute to adjust node positions.");
            } else {
                Attribute attribute = network.getNodeAttribute(id);
                Indexer indexer = this.createIndexer(attribute, 2048, this.isLogarithmicScale(this.logScale));
                Attribute coordinate = this.axis == Axis.X ? network.getNodeAttribute("x") : network.getNodeAttribute("y");
                double factor = indexer.range() > 0 ? 0.9 / (double)indexer.range() : 0.0;
                int i = 0;
                while (i < network.size()) {
                    coordinate.set(i, 0.05 + (double)indexer.index(i) * factor);
                    ++i;
                }
                this.figure.refresh();
            }
        }
    }

    public static enum Axis {
        X,
        Y;

    }
}

