/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.actions;

import ikor.model.ui.Application;
import ikor.model.ui.Editor;
import ikor.model.ui.Selector;
import ikor.util.indexer.Indexer;
import noesis.Attribute;
import noesis.AttributeNetwork;
import noesis.ui.model.NetworkFigure;
import noesis.ui.model.actions.NodeAttributeAction;

public class NodeAttributeSizeAction
extends NodeAttributeAction {
    private Application application;
    private NetworkFigure figure;
    private Selector attributes;
    private Editor<Boolean> logScale;
    public static final int DEFAULT_INDEX_SIZE = 16;

    public NodeAttributeSizeAction(Application application, NetworkFigure figure, Selector attributes, Editor<Boolean> logScale) {
        this.application = application;
        this.figure = figure;
        this.attributes = attributes;
        this.logScale = logScale;
    }

    @Override
    public void run() {
        AttributeNetwork network = (AttributeNetwork)this.application.get("network");
        if (network != null) {
            String id = this.getSelectedAttributeID(this.attributes);
            if (id == null) {
                this.application.message("Please, choose an attribute to adjust node sizes.");
            } else {
                Attribute attribute = network.getNodeAttribute(id);
                Indexer indexer = this.createIndexer(attribute, 16, this.isLogarithmicScale(this.logScale));
                this.figure.getRenderer().getNodeRenderer().setSizeIndexer(indexer);
                this.figure.refresh();
            }
        }
    }
}

