/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.actions;

import ikor.collection.List;
import ikor.model.data.IntegerModel;
import ikor.model.ui.Action;
import ikor.model.ui.Application;
import ikor.util.log.Log;
import java.lang.reflect.Constructor;
import noesis.Attribute;
import noesis.AttributeNetwork;
import noesis.Network;
import noesis.analysis.NodeScore;
import noesis.analysis.NodeScoreGroupTask;
import noesis.ui.model.NetworkModel;
import noesis.ui.model.actions.ForwardAction;
import noesis.ui.model.data.VectorUIModel;

public class NodeMultiScoreAction
extends Action {
    private Application application;
    private NetworkModel model;
    private Class measureClass;

    public NodeMultiScoreAction(Application application, NetworkModel model, Class metric) {
        this.application = application;
        this.model = model;
        this.measureClass = metric;
    }

    public NodeScoreGroupTask instantiateTask(Network network) {
        NodeScoreGroupTask task = null;
        try {
            Constructor constructor = this.measureClass.getConstructor(Network.class);
            task = (NodeScoreGroupTask)constructor.newInstance(network);
        }
        catch (Exception error) {
            Log.error("NodeMeasure: Unable to instantiate " + this.measureClass);
        }
        return task;
    }

    @Override
    public void run() {
        NodeScoreGroupTask task;
        AttributeNetwork network = this.model.getNetwork();
        if (network != null && (task = this.instantiateTask(network)) != null) {
            List metrics = (List)task.getResult();
            int m = 0;
            while (m < metrics.size()) {
                NodeScore measure = (NodeScore)metrics.get(m);
                String id = measure.getName();
                Attribute<Number> attribute = network.getNodeAttribute(id);
                if (attribute == null) {
                    attribute = new Attribute<Number>(measure.getName(), measure.getModel());
                    network.addNodeAttribute(attribute);
                }
                int i = 0;
                while (i < network.size()) {
                    if (measure.getModel() instanceof IntegerModel) {
                        attribute.set(i, (int)measure.get(i));
                    } else {
                        attribute.set(i, measure.get(i));
                    }
                    ++i;
                }
                this.model.setNetwork(network);
                VectorUIModel resultsUI = new VectorUIModel(this.application, measure.getDescription(), measure);
                ForwardAction forward = new ForwardAction(resultsUI);
                forward.run();
                ++m;
            }
        }
    }
}

