/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.actions;

import ikor.model.data.IntegerModel;
import ikor.model.ui.Action;
import ikor.model.ui.Application;
import ikor.util.log.Log;
import java.lang.reflect.Constructor;
import noesis.Attribute;
import noesis.AttributeNetwork;
import noesis.Network;
import noesis.analysis.NodeScore;
import noesis.analysis.NodeScoreTask;
import noesis.ui.model.NetworkModel;
import noesis.ui.model.NodeScoreUIModel;
import noesis.ui.model.actions.ForwardAction;
import noesis.ui.model.data.VectorUIModel;

public class NodeScoreAction
extends Action {
    private Application application;
    private NetworkModel model;
    private Class measureClass;

    public NodeScoreAction(Application application, NetworkModel model, Class metric) {
        this.application = application;
        this.model = model;
        this.measureClass = metric;
    }

    public Network getNetwork() {
        return this.model.getNetwork();
    }

    public Application getApplication() {
        return this.application;
    }

    public NodeScoreTask instantiateTask(Network network) {
        NodeScoreTask metrics = null;
        try {
            Constructor constructor = this.measureClass.getConstructor(Network.class);
            metrics = (NodeScoreTask)constructor.newInstance(network);
        }
        catch (Exception error) {
            Log.error("NodeScore: Unable to instantiate " + this.measureClass);
        }
        return metrics;
    }

    @Override
    public void run() {
        NodeScoreTask task;
        AttributeNetwork network = this.model.getNetwork();
        if (network != null && (task = this.instantiateTask(network)) != null) {
            if (task.getParameters().length > 0) {
                ForwardAction forward = new ForwardAction(new NodeScoreUIModel(this.application, this.model, this, task));
                forward.run();
            } else {
                this.computeScore(network, task);
            }
        }
    }

    public void computeScore(AttributeNetwork network, NodeScoreTask task) {
        NodeScore metrics = (NodeScore)task.getResult();
        String id = metrics.getName();
        Attribute<Number> attribute = network.getNodeAttribute(id);
        if (attribute == null) {
            attribute = new Attribute<Number>(metrics.getName(), metrics.getModel());
            network.addNodeAttribute(attribute);
        }
        int i = 0;
        while (i < network.size()) {
            if (metrics.getModel() instanceof IntegerModel) {
                attribute.set(i, (int)metrics.get(i));
            } else {
                attribute.set(i, metrics.get(i));
            }
            ++i;
        }
        this.model.setNetwork(network);
        VectorUIModel resultsUI = new VectorUIModel(this.application, metrics.getDescription(), metrics);
        ForwardAction forward = new ForwardAction(resultsUI);
        forward.run();
    }
}

