/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.data;

import ikor.math.Histogram;
import ikor.math.Vector;
import ikor.math.util.LogarithmicScale;
import ikor.model.graphics.DrawingTooltipProvider;
import ikor.model.graphics.charts.AxisRenderer;
import ikor.model.graphics.charts.BarRenderer;
import ikor.model.graphics.charts.Chart;
import ikor.model.ui.Figure;
import java.text.DecimalFormat;

public class HistogramFigure
extends Figure<Histogram> {
    private Chart chart = new Chart(500, 300);
    private static final int DEFAULT_WIDTH = 500;
    private static final int DEFAULT_HEIGHT = 300;

    public HistogramFigure(Histogram histogram) {
        this.chart.setBackgroundRenderer(null);
        this.setTooltipProvider(new HistogramTooltipProvider(histogram));
        this.setModel(histogram);
    }

    @Override
    public void setModel(Histogram histogram) {
        super.setModel(histogram);
        if (histogram != null) {
            this.reset();
            if (this.getTooltipProvider() != null) {
                ((HistogramTooltipProvider)this.getTooltipProvider()).setHistogram(histogram);
            }
            this.render();
        }
    }

    protected void reset() {
        Histogram histogram = (Histogram)this.getModel();
        this.chart.clear();
        this.chart.addSeries("data", (Vector)histogram, BarRenderer.class);
        this.chart.getAxisRenderer().grid(AxisRenderer.GridStyle.None, AxisRenderer.GridStyle.None);
        if (histogram.getScale() instanceof LogarithmicScale) {
            this.chart.setYScale(new LogarithmicScale(0.1, histogram.max()));
            this.chart.getAxisRenderer().grid(AxisRenderer.GridStyle.None, AxisRenderer.GridStyle.Logarithmic);
        } else {
            this.chart.getAxisRenderer().grid(AxisRenderer.GridStyle.None, AxisRenderer.GridStyle.None);
        }
    }

    public void render() {
        this.chart.render();
        super.setDrawing(this.chart);
        this.update();
    }

    protected Chart getChart() {
        return this.chart;
    }

    public class HistogramTooltipProvider
    implements DrawingTooltipProvider {
        private Histogram histogram;

        public HistogramTooltipProvider(Histogram histogram) {
            this.histogram = histogram;
        }

        public void setHistogram(Histogram histogram) {
            this.histogram = histogram;
        }

        @Override
        public String get(String id) {
            DecimalFormat df = new DecimalFormat("#.####");
            String tooltip = null;
            if (id.startsWith("data[")) {
                int bin = Integer.parseInt(id.substring(5, id.length() - 1));
                tooltip = "<html><b>[" + df.format(this.histogram.threshold(bin)) + ", " + df.format(this.histogram.threshold(bin + 1));
                tooltip = bin < this.histogram.size() - 1 ? String.valueOf(tooltip) + ")" : String.valueOf(tooltip) + "]";
                tooltip = String.valueOf(tooltip) + "</b><br/>n = " + (int)this.histogram.get(bin);
                tooltip = String.valueOf(tooltip) + "</html>";
            }
            return tooltip;
        }
    }
}

