/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.data;

import ikor.collection.CollectionFactory;
import ikor.collection.List;
import ikor.math.DenseMatrix;
import ikor.math.DenseVector;
import ikor.math.Histogram;
import ikor.math.Matrix;
import ikor.math.Vector;
import ikor.math.statistics.Distribution;
import ikor.math.util.LinearScale;
import ikor.math.util.LogarithmicScale;
import ikor.math.util.Scale;
import ikor.model.graphics.charts.Chart;
import ikor.model.graphics.charts.LineRenderer;
import ikor.model.graphics.charts.Series;
import ikor.model.graphics.charts.SeriesRenderer;
import java.text.DecimalFormat;
import noesis.ui.model.data.HistogramFigure;

public class HistogramFitFigure
extends HistogramFigure {
    private final int DISTRIBUTION_POINTS = 500;
    private List<String> labels;
    private List<Distribution> distributions;

    public HistogramFitFigure(Histogram histogram) {
        super(histogram);
        this.setTooltipProvider(new HistogramFitTooltipProvider(histogram));
        this.labels = CollectionFactory.createList();
        this.distributions = CollectionFactory.createList();
    }

    public void clearDistributions() {
        this.labels.clear();
        this.distributions.clear();
        this.reset();
        this.render();
    }

    public void addDistribution(Distribution distribution, String name) {
        this.labels.add(name);
        this.distributions.add(distribution);
        this.reset();
        this.render();
    }

    @Override
    public void reset() {
        super.reset();
        Chart chart = this.getChart();
        Histogram histogram = (Histogram)this.getModel();
        Scale dataScale = histogram.getScale();
        if (this.distributions != null) {
            DenseVector x = new DenseVector(501);
            DenseMatrix y = new DenseMatrix(this.distributions.size(), 501);
            double step = 0.002;
            int i = 0;
            while (i <= 500) {
                double value = dataScale.inverse((double)i * step);
                ((Vector)x).set(i, value);
                int d = 0;
                while (d < this.distributions.size()) {
                    ((Matrix)y).set(d, i, ((Distribution)this.distributions.get(d)).pdf(value));
                    ++d;
                }
                ++i;
            }
            int d = 0;
            while (d < this.distributions.size()) {
                Series series = new Series("distribution_" + d, x, y.getRow(d));
                LineRenderer lineRenderer = new LineRenderer(chart, series);
                lineRenderer.setXScale(histogram.getScale());
                if (histogram.getScale() instanceof LogarithmicScale) {
                    lineRenderer.setYScale(new LogarithmicScale(this.minPositive(y), y.max()));
                } else {
                    lineRenderer.setYScale(new LinearScale(0.0, y.max()));
                }
                chart.addSeries(series, (SeriesRenderer)lineRenderer);
                ++d;
            }
        }
    }

    private double minPositive(Matrix data) {
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < data.rows()) {
            int j = 0;
            while (j < data.columns()) {
                double value = data.get(i, j);
                if (value > 0.0 && value < min) {
                    min = value;
                }
                ++j;
            }
            ++i;
        }
        return min;
    }

    public class HistogramFitTooltipProvider
    extends HistogramFigure.HistogramTooltipProvider {
        public HistogramFitTooltipProvider(Histogram histogram) {
            super(histogram);
        }

        @Override
        public String get(String id) {
            String tooltip = super.get(id);
            DecimalFormat df = new DecimalFormat("#.####");
            if (tooltip == null && id.startsWith("distribution")) {
                int d = Integer.parseInt(id.substring(13, 14));
                tooltip = "<html><b>" + (String)HistogramFitFigure.this.labels.get(d) + "</b>";
                int i = Integer.parseInt(id.substring(15, id.length() - 1));
                double x = ((Histogram)HistogramFitFigure.this.getModel()).getScale().inverse((double)i / 500.0);
                tooltip = String.valueOf(tooltip) + "<br/>x = " + df.format(x);
                tooltip = String.valueOf(tooltip) + "<br/>pdf(x) = " + df.format(((Distribution)HistogramFitFigure.this.distributions.get(d)).pdf(x));
                tooltip = String.valueOf(tooltip) + "<br/>cdf(x) = " + df.format(((Distribution)HistogramFitFigure.this.distributions.get(d)).cdf(x));
                tooltip = String.valueOf(tooltip) + "</html>";
            }
            return tooltip;
        }
    }
}

