/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.data;

import ikor.math.Histogram;
import ikor.math.util.LogarithmicScale;
import ikor.math.util.Scale;
import ikor.model.ui.Action;
import java.lang.reflect.Constructor;
import noesis.ui.model.data.VectorUIModel;

public class HistogramScaleAction
extends Action {
    private VectorUIModel ui;
    private Class type;

    public HistogramScaleAction(VectorUIModel ui, Class type) {
        this.ui = ui;
        this.type = type;
    }

    public Scale createScale(Class type, double min, double max) {
        Scale scale = null;
        try {
            Class[] constructorArguments = new Class[]{Double.TYPE, Double.TYPE};
            Constructor constructor = type.getDeclaredConstructor(constructorArguments);
            Object[] arguments = new Object[]{min, max};
            scale = (Scale)constructor.newInstance(arguments);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return scale;
    }

    @Override
    public void run() {
        int bins = this.ui.getHistogram().size();
        double min = this.type == LogarithmicScale.class ? Math.max(this.ui.getData().min(), 1.0) : Math.min(this.ui.getData().min(), 0.0);
        double max = this.ui.getData().max();
        Scale scale = this.createScale(this.type, min, max);
        Histogram h = this.ui.createHistogram(bins, scale);
        this.ui.setHistogram(h);
    }
}

