/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.data;

import ikor.math.util.LinearScale;
import ikor.math.util.LogarithmicScale;
import ikor.model.ui.Action;
import ikor.model.ui.Application;
import ikor.model.ui.Menu;
import ikor.model.ui.Option;
import ikor.model.ui.Separator;
import noesis.ui.model.HelpMenu;
import noesis.ui.model.actions.ExitAction;
import noesis.ui.model.data.FitNormalAction;
import noesis.ui.model.data.FitParetoAction;
import noesis.ui.model.data.FitPoissonAction;
import noesis.ui.model.data.HistogramBinsAction;
import noesis.ui.model.data.HistogramScaleAction;
import noesis.ui.model.data.VectorUIModel;
import noesis.ui.model.data.VectorUISaveAction;

public class VectorUIMenu
extends Menu {
    private Menu data;
    private Menu view;
    private Menu fit;
    private Menu help;

    public VectorUIMenu(VectorUIModel ui) {
        super("NOESIS Data Menu");
        Application app = ui.getApplication();
        this.data = this.createDataMenu(app, ui);
        this.view = this.createViewMenu(app, ui);
        this.fit = this.createFitMenu(app, ui);
        this.help = new HelpMenu(app);
        this.add(this.data);
        this.add(this.view);
        this.add(this.fit);
        this.add(this.help);
    }

    public Menu createDataMenu(Application app, VectorUIModel ui) {
        Menu data = new Menu("Data");
        data.setIcon(app.url("icons/download.png"));
        Option saveTXT = new Option("Save data...", new VectorUISaveAction(ui, "txt"));
        saveTXT.setIcon(app.url("icons/download.png"));
        data.add(saveTXT);
        data.add(new Separator());
        Option saveSVG = new Option("Export SVG image", new VectorUISaveAction(ui, "svg"));
        saveSVG.setIcon(app.url("icons/chart.png"));
        data.add(saveSVG);
        Option savePNG = new Option("Export PNG image", new VectorUISaveAction(ui, "png"));
        savePNG.setIcon(app.url("icons/chart.png"));
        data.add(savePNG);
        Option saveJPG = new Option("Export JPG image", new VectorUISaveAction(ui, "jpg"));
        saveJPG.setIcon(app.url("icons/chart.png"));
        data.add(saveJPG);
        data.add(new Separator());
        Option exit = new Option("Exit", new ExitAction(ui));
        exit.setIcon(app.url("icons/exit.png"));
        data.add(exit);
        return data;
    }

    public Menu createViewMenu(Application app, VectorUIModel ui) {
        Menu view = new Menu("View");
        view.setIcon(app.url("icons/chart.png"));
        Option binIncrease = new Option("Increase number of bins", new HistogramBinsAction(ui, 1), 119);
        binIncrease.setIcon(app.url("icons/chart.png"));
        view.add(binIncrease);
        Option binDecrease = new Option("Decrease number of bins", new HistogramBinsAction(ui, -1), 118);
        binDecrease.setIcon(app.url("icons/chart.png"));
        view.add(binDecrease);
        view.add(new Separator());
        Option linearScale = new Option("Linear scale", new HistogramScaleAction(ui, LinearScale.class));
        linearScale.setIcon(app.url("icons/chart.png"));
        view.add(linearScale);
        Option logScale = new Option("Logarithmic scale", new HistogramScaleAction(ui, LogarithmicScale.class));
        logScale.setIcon(app.url("icons/chart.png"));
        view.add(logScale);
        return view;
    }

    public Menu createFitMenu(Application app, final VectorUIModel ui) {
        Menu fit = new Menu("Fit");
        fit.setIcon(app.url("icons/calculator.png"));
        Option gaussian = new Option("Fit a Gaussian distribution");
        gaussian.setIcon(app.url("icons/calculator.png"));
        gaussian.setAction(new FitNormalAction(app, ui));
        fit.add(gaussian);
        Option poisson = new Option("Fit a Poisson distribution");
        poisson.setIcon(app.url("icons/calculator.png"));
        poisson.setAction(new FitPoissonAction(app, ui));
        fit.add(poisson);
        Option pareto = new Option("Fit a Pareto distribution (i.e. power law)");
        pareto.setIcon(app.url("icons/calculator.png"));
        pareto.setAction(new FitParetoAction(app, ui));
        fit.add(pareto);
        fit.add(new Separator());
        Option clear = new Option("Clear distribution fit");
        clear.setIcon(app.url("icons/chart.png"));
        clear.setAction(new Action(){

            @Override
            public void run() {
                ui.getFigure().clearDistributions();
            }
        });
        fit.add(clear);
        return fit;
    }
}

