/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.data;

import ikor.math.Decimal;
import ikor.math.Histogram;
import ikor.math.Vector;
import ikor.math.util.LinearScale;
import ikor.math.util.Scale;
import ikor.model.data.DecimalModel;
import ikor.model.ui.Application;
import ikor.model.ui.Label;
import ikor.model.ui.Option;
import ikor.model.ui.Separator;
import ikor.model.ui.UIModel;
import ikor.model.ui.Viewer;
import noesis.ui.model.actions.ExitAction;
import noesis.ui.model.data.HistogramFitFigure;
import noesis.ui.model.data.VectorUIMenu;

public class VectorUIModel
extends UIModel {
    private Vector data;
    private int bins;
    private Histogram histogram;
    private HistogramFitFigure figure;
    private Scale scale;

    public VectorUIModel(Application app, String title, Vector data) {
        super(app, title);
        this.data = data;
        this.setIcon(app.url("icon.gif"));
        this.add(new Option("$exit", new ExitAction(this)));
        this.add(new Label("<html><b><center>" + title + "</center></b></html>"));
        this.add(new Separator());
        UIModel content = new UIModel(app, "Content panel");
        this.add(content);
        this.bins = (int)Math.sqrt(data.size());
        this.histogram = this.createHistogram(this.bins);
        this.figure = new HistogramFitFigure(this.histogram);
        content.add(this.figure);
        UIModel stats = new UIModel(app, "Statistics");
        stats.add(this.viewer("Minimum", data.min()));
        stats.add(this.viewer("Maximum", data.max()));
        stats.add(this.viewer("Mean", data.average()));
        stats.add(this.viewer("Deviation", data.deviation()));
        stats.add(this.viewer("Variance", data.variance()));
        Viewer<Integer> size = new Viewer<Integer>("Size", Integer.class);
        size.setData(data.size());
        stats.add(size);
        content.add(stats);
        VectorUIMenu menu = new VectorUIMenu(this);
        this.add(menu);
    }

    private Viewer<Decimal> viewer(String title, double value) {
        DecimalModel decimalModel = new DecimalModel();
        decimalModel.setDecimalDigits(4);
        Viewer<Decimal> viewer = new Viewer<Decimal>(title, decimalModel);
        viewer.setData(new Decimal(value));
        return viewer;
    }

    public UIModel buttons(Application app) {
        UIModel buttons = new UIModel(app, "Button bar");
        buttons.setAlignment(UIModel.Alignment.ADJUST);
        Option ok = new Option("OK");
        ok.setIcon(app.url("icon.gif"));
        ok.setAction(new ExitAction(this));
        buttons.add(ok);
        return buttons;
    }

    public Vector getData() {
        return this.data;
    }

    public Histogram getHistogram() {
        return this.histogram;
    }

    public HistogramFitFigure getFigure() {
        return this.figure;
    }

    public void setHistogram(Histogram histogram) {
        this.histogram = histogram;
        this.figure.setModel(histogram);
    }

    public Histogram createHistogram(int bins, Scale scale) {
        this.scale = scale;
        return new Histogram(bins, this.data, scale);
    }

    public Histogram createHistogram(int bins) {
        if (this.scale == null) {
            this.scale = new LinearScale(Math.min(this.data.min(), 0.0), this.data.max());
        }
        return this.createHistogram(bins, this.scale);
    }
}

