/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.data;

import ikor.math.Vector;
import ikor.model.graphics.io.DrawingWriter;
import ikor.model.graphics.io.DrawingWriterFactory;
import ikor.model.ui.Action;
import ikor.model.ui.Figure;
import ikor.util.log.Log;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import noesis.ui.model.data.VectorUIModel;

public class VectorUISaveAction
extends Action {
    private VectorUIModel ui;
    private String format;
    private ikor.model.ui.File file;

    public VectorUISaveAction(VectorUIModel ui, String format) {
        this.ui = ui;
        this.format = format;
        this.file = new ikor.model.ui.File(ui.getApplication(), "Save histogram...", "Save", new FileCommandAction());
    }

    @Override
    public void run() {
        this.file.setUrl("histogram." + this.format);
        this.file.getApplication().run(this.file);
    }

    public class FileCommandAction
    extends Action {
        @Override
        public void run() {
            block6: {
                String filename = VectorUISaveAction.this.file.getUrl();
                if (!this.checkFilename(filename)) {
                    filename = null;
                }
                if (filename != null) {
                    try {
                        if (VectorUISaveAction.this.format.equals("txt") || VectorUISaveAction.this.format.equals("csv")) {
                            this.saveData(filename, VectorUISaveAction.this.ui.getData(), VectorUISaveAction.this.format);
                            break block6;
                        }
                        if (VectorUISaveAction.this.format.equals("png") || VectorUISaveAction.this.format.equals("jpg") || VectorUISaveAction.this.format.equals("svg")) {
                            this.saveFigure(filename, VectorUISaveAction.this.ui.getFigure(), VectorUISaveAction.this.format);
                            break block6;
                        }
                        throw new IOException("Unknown file format.");
                    }
                    catch (IOException ioe) {
                        Log.error("IO error - " + ioe);
                    }
                }
            }
        }

        private boolean checkFilename(String filename) {
            if (filename != null) {
                File file = new File(filename);
                if (file.exists()) {
                    return VectorUISaveAction.this.ui.confirm("Overwrite existing file?");
                }
                return true;
            }
            return false;
        }

        private void saveData(String filename, Vector data, String format) throws IOException {
            FileWriter output = new FileWriter(filename);
            BufferedWriter writer = new BufferedWriter(output);
            int i = 0;
            while (i < data.size()) {
                writer.write(String.valueOf(data.get(i)) + "\n");
                ++i;
            }
            writer.close();
        }

        private void saveFigure(String filename, Figure figure, String format) throws IOException {
            FileOutputStream stream = new FileOutputStream(filename);
            BufferedOutputStream writer = new BufferedOutputStream(stream);
            DrawingWriter dw = DrawingWriterFactory.create(figure.getDrawing(), format);
            dw.write(writer);
            writer.close();
        }
    }
}

