/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.networks;

import ikor.model.data.IntegerModel;
import ikor.model.ui.Action;
import ikor.model.ui.Application;
import ikor.model.ui.Editor;
import ikor.model.ui.Option;
import noesis.AttributeNetwork;
import noesis.algorithms.visualization.FruchtermanReingoldLayout;
import noesis.model.random.BarabasiAlbertNetwork;
import noesis.ui.model.networks.NewNetworkUI;

public class BarabasiAlbertNetworkUI
extends NewNetworkUI {
    Editor<Integer> nodeEditor;
    Editor<Integer> linkEditor;

    public BarabasiAlbertNetworkUI(Application app) {
        super(app, "New Barabasi-Albert network...");
        this.setIcon(app.url("icon.gif"));
        IntegerModel nodeCountModel = new IntegerModel();
        nodeCountModel.setMinimumValue(0);
        nodeCountModel.setMaximumValue(1000);
        this.nodeEditor = new Editor<Integer>("Number of network nodes", nodeCountModel);
        this.nodeEditor.setIcon(app.url("icons/calculator.png"));
        this.nodeEditor.setData(50);
        this.add(this.nodeEditor);
        IntegerModel degreeModel = new IntegerModel();
        nodeCountModel.setMinimumValue(0);
        nodeCountModel.setMaximumValue(1000);
        this.linkEditor = new Editor<Integer>("Links for each new node", degreeModel);
        this.linkEditor.setIcon(app.url("icons/calculator.png"));
        this.linkEditor.setData(2);
        this.add(this.linkEditor);
        Option ok = new Option("Create");
        ok.setIcon(app.url("icon.gif"));
        ok.setAction(new BarabasiAlbertNetworkAction(this));
        this.add(ok);
    }

    public class BarabasiAlbertNetworkAction
    extends Action {
        private BarabasiAlbertNetworkUI ui;

        public BarabasiAlbertNetworkAction(BarabasiAlbertNetworkUI ui) {
            this.ui = ui;
        }

        @Override
        public void run() {
            int nodes = (Integer)this.ui.nodeEditor.getData();
            int links = (Integer)this.ui.linkEditor.getData();
            BarabasiAlbertNetwork random = new BarabasiAlbertNetwork(nodes, links);
            AttributeNetwork network = BarabasiAlbertNetworkUI.this.createAttributeNetwork(random, "Barabasi-Albert's preferential attachment network", new FruchtermanReingoldLayout());
            this.ui.set("network", network);
            this.ui.exit();
        }
    }
}

