/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.networks;

import ikor.model.data.IntegerModel;
import ikor.model.ui.Action;
import ikor.model.ui.Application;
import ikor.model.ui.Editor;
import ikor.model.ui.Option;
import noesis.AttributeNetwork;
import noesis.algorithms.visualization.BinaryTreeLayout;
import noesis.model.regular.BinaryTreeNetwork;
import noesis.ui.model.networks.NewNetworkUI;

public class BinaryTreeNetworkUI
extends NewNetworkUI {
    Editor<Integer> sizeEditor;

    public BinaryTreeNetworkUI(Application app) {
        super(app, "New binary tree network...");
        this.setIcon(app.url("icon.gif"));
        IntegerModel dimensionModel = new IntegerModel();
        dimensionModel.setMinimumValue(0);
        dimensionModel.setMaximumValue(1000);
        this.sizeEditor = new Editor<Integer>("Number of tree nodes", dimensionModel);
        this.sizeEditor.setIcon(app.url("icons/calculator.png"));
        this.sizeEditor.setData(15);
        this.add(this.sizeEditor);
        Option ok = new Option("Create");
        ok.setIcon(app.url("icon.gif"));
        ok.setAction(new BinaryTreeNetworkAction(this));
        this.add(ok);
    }

    public class BinaryTreeNetworkAction
    extends Action {
        private BinaryTreeNetworkUI ui;

        public BinaryTreeNetworkAction(BinaryTreeNetworkUI ui) {
            this.ui = ui;
        }

        @Override
        public void run() {
            int size = (Integer)this.ui.sizeEditor.getData();
            BinaryTreeNetwork tree = new BinaryTreeNetwork(size);
            AttributeNetwork network = BinaryTreeNetworkUI.this.createAttributeNetwork(tree, "Binary tree network", new BinaryTreeLayout());
            this.ui.set("network", network);
            this.ui.exit();
        }
    }
}

