/*
 * Decompiled with CFR 0.152.
 */
package noesis.ui.model.networks;

import ikor.model.data.IntegerModel;
import ikor.model.ui.Action;
import ikor.model.ui.Application;
import ikor.model.ui.Editor;
import ikor.model.ui.Option;
import noesis.AttributeNetwork;
import noesis.algorithms.visualization.CircularLayout;
import noesis.model.regular.CompleteNetwork;
import noesis.ui.model.networks.NewNetworkUI;

public class CompleteNetworkUI
extends NewNetworkUI {
    Editor<Integer> nodeCountEditor;

    public CompleteNetworkUI(Application app) {
        super(app, "New complete network...");
        this.setIcon(app.url("icon.gif"));
        IntegerModel nodeCountModel = new IntegerModel();
        nodeCountModel.setMinimumValue(0);
        nodeCountModel.setMaximumValue(100);
        this.nodeCountEditor = new Editor<Integer>("Number of network nodes", nodeCountModel);
        this.nodeCountEditor.setIcon(app.url("icons/calculator.png"));
        this.nodeCountEditor.setData(15);
        this.add(this.nodeCountEditor);
        Option ok = new Option("Create");
        ok.setIcon(app.url("icon.gif"));
        ok.setAction(new CompleteNetworkAction(this));
        this.add(ok);
    }

    public class CompleteNetworkAction
    extends Action {
        private CompleteNetworkUI ui;

        public CompleteNetworkAction(CompleteNetworkUI ui) {
            this.ui = ui;
        }

        @Override
        public void run() {
            int nodes = (Integer)this.ui.nodeCountEditor.getData();
            CompleteNetwork regular = new CompleteNetwork(nodes);
            AttributeNetwork network = CompleteNetworkUI.this.createAttributeNetwork(regular, "Complete network", new CircularLayout());
            this.ui.set("network", network);
            this.ui.exit();
        }
    }
}

